/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.postprocessor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class PlanExecuteRecordInfoFillPostProcessor
implements IDataInspectParamPostProcessor {
    private IControlRepository controlRepository = FpmServiceFactory.getBizService(IControlRepository.class);

    @Override
    public void postProcess(InspectContext inspectContext, InspectParam dataInspectParam) {
        List<BillBizInfo> billBizInfoList = dataInspectParam.getBillBizInfoList();
        HashSet<Long> billIds = new HashSet<Long>(billBizInfoList.size());
        HashSet<String> entityType = new HashSet<String>(billBizInfoList.size());
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = inspectContext.getBusinessBillExecuteRecordInfo();
        for (BillBizInfo billBizInfo : billBizInfoList) {
            Long billId = billBizInfo.getBillId();
            billIds.add(billId);
            entityType.add(billBizInfo.getEntityType());
            List<ControlBOTPInfo> upperBillBIzInfoList = businessBillExecuteRecordInfo.getUpperBillBIzInfoList(billId);
            upperBillBIzInfoList.forEach(controlBOTPInfo -> {
                billIds.add(controlBOTPInfo.getId());
                entityType.add(controlBOTPInfo.getEntityType());
            });
            List<ControlBOTPInfo> downBillBizInfoList = businessBillExecuteRecordInfo.getDownBillBizInfoList(billId);
            downBillBizInfoList.forEach(controlBOTPInfo -> {
                billIds.add(controlBOTPInfo.getId());
                entityType.add(controlBOTPInfo.getEntityType());
            });
        }
        List<PlanExecuteRecord> planExecuteRecordList = this.controlRepository.loadPlanExecuteRecordBySystem(billIds, entityType, Collections.singleton(inspectContext.getSystem().getId()));
        planExecuteRecordList.stream().filter(planExecuteRecord -> planExecuteRecord.getExecuteStatus().isSuccess()).forEach(businessBillExecuteRecordInfo::addPlanExecuteRecord);
    }
}

