/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.query.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.domain.enums.InspectionType;
import kd.tmc.fpm.business.domain.model.inspection.InspectionConfig;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtConsistencyLog;
import kd.tmc.fpm.business.mvc.repository.inspection.IInspectionConfigRepository;
import kd.tmc.fpm.business.mvc.repository.inspection.IInspectionLogRepository;
import kd.tmc.fpm.business.mvc.repository.inspection.impl.InspectionConfigRepository;
import kd.tmc.fpm.business.mvc.repository.inspection.impl.InspectionLogRepository;
import kd.tmc.fpm.business.mvc.service.dto.InspectLogQueryParamDTO;
import kd.tmc.fpm.business.mvc.service.inspection.query.InspectLogQueryService;

public class InspectLogQueryServiceImpl
implements InspectLogQueryService {
    private IInspectionConfigRepository configRepository;
    private IInspectionLogRepository logRepository = new InspectionLogRepository();

    public InspectLogQueryServiceImpl() {
        this.configRepository = new InspectionConfigRepository();
    }

    @Override
    public List<AmtConsistencyLog> queryErrorLogsByParam(InspectLogQueryParamDTO queryParamDTO) {
        List<InspectionConfig> inspectionConfigs = this.configRepository.queryEnableConfigBySystemId(queryParamDTO.getSystemId());
        if (CollectionUtils.isEmpty(inspectionConfigs)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        String inspectLogScope = queryParamDTO.getInspectLogScope();
        List filterConfigs = inspectionConfigs.stream().filter(item -> inspectLogScope.equals(item.getInspectionScope().getNumber())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterConfigs)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<Long> configIds = filterConfigs.stream().map(InspectionConfig::getId).collect(Collectors.toList());
        List<AmtConsistencyLog> amtConsistencyLogs = this.logRepository.queryBillInspectionLogByParam(configIds, queryParamDTO.getExecuteTimeStart(), queryParamDTO.getExecuteTimeEnd());
        if (CollectionUtils.isEmpty(amtConsistencyLogs)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return amtConsistencyLogs.stream().filter(item -> InspectionType.EXEC_CONSISTENCY_INSPECTION == item.getInspectionType()).filter(item -> item.getExecResult().isException()).collect(Collectors.toList());
    }
}

