/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.repair;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.LRUCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.inspection.InspectDateRange;
import kd.tmc.fpm.business.domain.model.inspection.log.RepairRecord;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.upgrade.DataResetConfig;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.control.factory.RelateReportDataManagerFactory;
import kd.tmc.fpm.business.mvc.service.inspection.context.RepairContext;
import kd.tmc.fpm.business.mvc.service.inspection.repair.IInspectDataRepair;
import kd.tmc.fpm.business.mvc.service.upgrade.manage.DataResetManager;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DataSetUtil;
import org.apache.commons.collections.CollectionUtils;

public class AmtConsistencyDataRepairService
implements IInspectDataRepair {
    private final IDataSaveService dataSaveService;
    private final IReportDataQueryService reportDataQueryService;
    private final Log logger = LogFactory.getLog(AmtConsistencyDataRepairService.class);
    private final LRUCache<Long, ReportData> lruCache = new LRUCache(1024);
    public static final int BATCH_SIZE = 1000;
    List<Long> successIdList;
    private RepairRecord repairRecord;

    public AmtConsistencyDataRepairService() {
        this.dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
        this.reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
        this.successIdList = new ArrayList<Long>(1024);
        this.initRepairRecord();
    }

    private void initRepairRecord() {
        this.repairRecord = new RepairRecord();
        this.repairRecord.setId(DB.genGlobalLongId());
        this.repairRecord.setRepairDate(new Date());
        this.repairRecord.setExecuteMan(RequestContext.get().getCurrUserId());
    }

    @Override
    public FpmOperateResult<Object> inspectDataRepair(RepairContext repairContext) {
        FpmOperateResult<Object> fpmOperateResult = FpmOperateResult.success();
        try {
            this.doRepair(repairContext);
            if (!this.updateStatus(repairContext)) {
                fpmOperateResult.setSuccess(false);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u4fee\u590d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RepairDataTask_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return fpmOperateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRepair(RepairContext repairContext) {
        DataResetConfig dataResetConfig = new DataResetConfig();
        dataResetConfig.setResetData(true);
        dataResetConfig.getSystemIds().add(repairContext.getSystem().getId());
        InspectDateRange inspectDateRange = repairContext.getInspectDateRange();
        List<PeriodMember> allPeriodMemberList = inspectDateRange.getAllPeriodMemberList();
        Set<Long> periodTypeId = allPeriodMemberList.stream().map(PeriodMember::getPeriodTypeId).collect(Collectors.toSet());
        dataResetConfig.setReportTypeIds(periodTypeId);
        dataResetConfig.setPeriodSet(inspectDateRange.getAllPeriodMemberIdList());
        DataResetManager dataResetManager = new DataResetManager(dataResetConfig);
        DataSet dataSet = this.getDataSet(dataResetConfig);
        try {
            FpmOperateResult result = CommonUtils.processInTransactionRequiresNew(() -> {
                long total = 0L;
                int count = 0;
                ArrayList<PlanExecuteRecord> planExecuteRecordList = new ArrayList<PlanExecuteRecord>(10000);
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    PlanExecuteRecord convert = this.convert(next);
                    planExecuteRecordList.add(convert);
                    if (++count != 1000) continue;
                    this.doUpdate(planExecuteRecordList, dataResetManager);
                    planExecuteRecordList.clear();
                    total += (long)count;
                    count = 0;
                }
                if (EmptyUtil.isNoEmpty(planExecuteRecordList)) {
                    total += (long)count;
                    this.doUpdate(planExecuteRecordList, dataResetManager);
                }
                this.logger.info("\u5df2\u5b8c\u6210\uff0c\u6267\u884c\u8bb0\u5f55\u603b\u6761\u6570\uff1a{}", (Object)total);
                return FpmOperateResult.success();
            });
            if (!result.isSuccess()) {
                throw new KDBizException(String.join((CharSequence)",", result.getMessageList()));
            }
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet(dataSet);
            throw throwable;
        }
        DataSetUtil.closeDataSet(dataSet);
    }

    private void doUpdate(List<PlanExecuteRecord> planExecuteRecordList, DataResetManager dataResetManager) {
        Map<Long, Set<Long>> systemReportDataIdMap = planExecuteRecordList.stream().map(PlanExecuteRecord::getMatchedReportDataList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.groupingBy(ReportData::getSystemId, Collectors.mapping(ReportData::getId, Collectors.toSet())));
        List<ReportData> reportDataList = this.getReportDataList(systemReportDataIdMap);
        dataResetManager.clearAmt(reportDataList);
        Map<Long, ReportData> reportDataMap = reportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
        ControlAmountCache controlAmountCache = this.getControlAmountCache(reportDataList);
        this.updateControlAmountCache(planExecuteRecordList, reportDataMap, controlAmountCache);
        this.doUpdateData(reportDataMap, controlAmountCache, dataResetManager);
    }

    private List<ReportData> getReportDataList(Map<Long, Set<Long>> systemReportDataIdMap) {
        ArrayList<ReportData> allReportDataList = new ArrayList<ReportData>(1024);
        for (Map.Entry<Long, Set<Long>> entry : systemReportDataIdMap.entrySet()) {
            ArrayList<Long> reportDataIdList = new ArrayList<Long>((Collection)entry.getValue());
            ArrayList<ReportData> cachedList = new ArrayList<ReportData>(reportDataIdList.size());
            HashSet cachedId = new HashSet(reportDataIdList.size());
            reportDataIdList.forEach(dataId -> {
                ReportData reportData = (ReportData)this.lruCache.get(dataId);
                if (Objects.nonNull(reportData)) {
                    cachedId.add(dataId);
                    cachedList.add(reportData);
                }
            });
            reportDataIdList.removeIf(cachedId::contains);
            if (EmptyUtil.isEmpty(reportDataIdList)) {
                return cachedList;
            }
            List<ReportData> reportDataList = this.reportDataQueryService.queryReportData(t -> {
                t.setIdList(reportDataIdList);
                t.setNeedDimIfValueIsNotEmpty(true);
            });
            reportDataList.addAll(cachedList);
            allReportDataList.addAll(reportDataList);
        }
        return allReportDataList;
    }

    private void updateControlAmountCache(List<PlanExecuteRecord> planExecuteRecordList, Map<Long, ReportData> reportDataMap, ControlAmountCache controlAmountCache) {
        for (PlanExecuteRecord planExecuteRecord : planExecuteRecordList) {
            BigDecimal reportActAmount = planExecuteRecord.getActAmount();
            List<ReportData> matchedReportDataList = planExecuteRecord.getMatchedReportDataList();
            PlanExecuteOpType executeOpType = planExecuteRecord.getExecuteOpType();
            for (ReportData reportData : matchedReportDataList) {
                Long reportDataId = reportData.getId();
                if (!reportDataMap.containsKey(reportDataId)) continue;
                ReportData rd = reportDataMap.get(reportDataId);
                if (executeOpType == PlanExecuteOpType.PRE_OCCUPY_WRITE || executeOpType == PlanExecuteOpType.PRE_OCCUPY_RELEASE) {
                    controlAmountCache.updateLockAmount(rd.getId(), rd.getReportActAmount(reportActAmount));
                    continue;
                }
                if (executeOpType != PlanExecuteOpType.WRITE && executeOpType != PlanExecuteOpType.RELEASE && executeOpType != PlanExecuteOpType.UPDATE) continue;
                controlAmountCache.updateActAmount(rd.getId(), rd.getReportActAmount(reportActAmount));
            }
        }
    }

    private ControlAmountCache getControlAmountCache(List<ReportData> reportDataList) {
        Map<Long, List<ReportData>> systemReportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getSystemId));
        ControlAmountCache controlAmountCache = new ControlAmountCache();
        for (Map.Entry<Long, List<ReportData>> entry : systemReportDataMap.entrySet()) {
            controlAmountCache.init(entry.getValue(), entry.getKey());
        }
        return controlAmountCache;
    }

    private void doUpdateData(Map<Long, ReportData> reportDataMap, ControlAmountCache controlAmountCache, DataResetManager dataResetManager) {
        List<ControlAmountCache.AmountInfo> updateAmountInfoList = controlAmountCache.getUpdateData();
        List<ReportData> needUpdateReportDataList = updateAmountInfoList.stream().map(ControlAmountCache.AmountInfo::getReportDataId).map(reportDataMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        IRelateReportDataManager relateReportDataManager = RelateReportDataManagerFactory.getRelateReportDataManager(needUpdateReportDataList);
        Map amountInfoMap = updateAmountInfoList.stream().collect(Collectors.toMap(ControlAmountCache.AmountInfo::getReportDataId, Function.identity(), (a, b) -> a));
        for (ReportData reportData : needUpdateReportDataList) {
            ControlAmountCache.AmountInfo amountInfo = (ControlAmountCache.AmountInfo)amountInfoMap.get(reportData.getId());
            reportData.addLockAmt(amountInfo.getLockDiffAmt());
            reportData.addActAmt(amountInfo.getActDiffAmt());
        }
        List<ReportData> relateReportDataListBySource = relateReportDataManager.getRelateReportDataListBySourceCanDiff(needUpdateReportDataList);
        relateReportDataListBySource.addAll(needUpdateReportDataList);
        List<ReportData> reportDataList = relateReportDataManager.reCalculateRelateDataByDAGAndCompletionIndex(relateReportDataListBySource);
        reportDataList.addAll(needUpdateReportDataList);
        reportDataList.forEach(rd -> {
            ReportData cfr_ignored_0 = (ReportData)this.lruCache.put((Object)rd.getId(), rd);
        });
        this.updateDataBase(reportDataList, dataResetManager);
    }

    private void updateDataBase(List<ReportData> updateData, DataResetManager dataResetManager) {
        ArrayList<String> errorMsg = new ArrayList<String>(10);
        for (ReportData reportData : updateData) {
            FpmOperateResult result = CommonUtils.processInTransaction(() -> {
                List<ReportData> reportDataList = Collections.singletonList(reportData);
                dataResetManager.resetData(reportDataList);
                this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_reportdatamain set flockamt=? ,frealamt=? where fentryid=?", reportDataList, (t, d) -> {
                    d.add(t.getLockAmt());
                    d.add(t.getActAmt());
                    d.add(t.getId());
                });
                return FpmOperateResult.success(reportData);
            });
            if (!result.isSuccess()) {
                errorMsg.add(result.getMessageList().get(0));
                continue;
            }
            this.successIdList.add(((ReportData)result.getData()).getId());
        }
        if (errorMsg.size() != 0) {
            this.logger.info("\u6570\u636e\u4fee\u590d\u5931\u8d25\uff1a", (Object)String.join((CharSequence)",", errorMsg));
        }
    }

    private DataSet getDataSet(DataResetConfig dataResetConfig) {
        String selectFields = String.join((CharSequence)",", "id", "bodysys.id", "billno", "createtime", "relaterecordid", "originalrecordid", "bizbillid", "reportdataid", "matchedreportdataids", "rate", "realamt", "planexecuteop");
        QFilter qFilter = new QFilter("deleteflag", "=", (Object)"0").and("executeoperatorstatus", "=", (Object)PlanExecuteStatus.SUCCESSFUL.getValue());
        if (EmptyUtil.isNoEmpty(dataResetConfig.getSystemIds())) {
            qFilter = qFilter.and("bodysys.id", "in", dataResetConfig.getSystemIds());
        }
        if (EmptyUtil.isNoEmpty(dataResetConfig.getBillIds())) {
            qFilter = qFilter.and("bizbillid", "in", dataResetConfig.getBillIds());
        }
        if (EmptyUtil.isNoEmpty(dataResetConfig.getReportTypeIds())) {
            qFilter = qFilter.and("reporttype.id", "in", dataResetConfig.getReportTypeIds());
        }
        qFilter = CollectionUtils.isNotEmpty(dataResetConfig.getPeriodSet()) ? qFilter.and("reportperiod", "in", dataResetConfig.getPeriodSet()) : qFilter.and("createtime", ">=", (Object)dataResetConfig.getStartDate()).and("createtime", "<=", (Object)dataResetConfig.getEndDate());
        this.logger.info("\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)qFilter);
        return QueryServiceHelper.queryDataSet((String)"queryExecutePlanRecord", (String)"fpm_executeplan", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"createtime");
    }

    public PlanExecuteRecord convert(Row row) {
        PlanExecuteRecord planExecuteRecord = new PlanExecuteRecord();
        planExecuteRecord.setId(row.getLong("id"));
        planExecuteRecord.setRecordNumber(row.getString("billno"));
        planExecuteRecord.setRelateRecordId(row.getLong("relaterecordid"));
        planExecuteRecord.setOriginalRecordId(row.getLong("originalrecordid"));
        planExecuteRecord.setRate(row.getBigDecimal("rate"));
        planExecuteRecord.setActAmount(row.getBigDecimal("realamt"));
        planExecuteRecord.setExecuteOpType(ITypeEnum.getByNumber(row.getString("planexecuteop"), PlanExecuteOpType.class));
        planExecuteRecord.setSystemId(row.getLong("bodysys.id"));
        BillBizInfo billBizInfo = new BillBizInfo();
        billBizInfo.setBillId(row.getLong("bizbillid"));
        planExecuteRecord.setBillBizInfo(billBizInfo);
        ReportData reportData = new ReportData();
        reportData.setId(row.getLong("reportdataid"));
        String reportDataIds = row.getString("matchedreportdataids");
        String[] split = reportDataIds.split(",");
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(split.length);
        for (String reportDataId : split) {
            ReportData rd = new ReportData();
            long id = Long.parseLong(reportDataId);
            rd.setId(id);
            rd.setSystemId(planExecuteRecord.getSystemId());
            reportDataList.add(rd);
        }
        planExecuteRecord.setMatchedReportDataList(CommonUtils.getDistinctList(reportDataList, ReportData::getId));
        return planExecuteRecord;
    }

    private boolean updateStatus(RepairContext repairContext) {
        Long inspectionLogId = repairContext.getInspectionLogId();
        String repairResultProp = String.join((CharSequence)".", "entry_consistency_error", "e_cons_repairresult");
        String reportDataProp = String.join((CharSequence)".", "entry_consistency_error", "e_cons_reportdataid");
        QFilter qFilter = new QFilter(repairResultProp, "=", (Object)InspectionRepairResult.PENDING.getNumber()).and(new QFilter("id", "=", (Object)inspectionLogId));
        DynamicObjectCollection pendingRecords = QueryServiceHelper.query((String)"fpm_inspection_log", (String)reportDataProp, (QFilter[])new QFilter[]{qFilter});
        List pendingReportDataIdList = pendingRecords.stream().map(dy -> dy.getLong(reportDataProp)).collect(Collectors.toList());
        List updateToSuccessList = pendingReportDataIdList.stream().filter(this.successIdList::contains).collect(Collectors.toList());
        List updateToFailList = pendingReportDataIdList.stream().filter(id -> !this.successIdList.contains(id)).collect(Collectors.toList());
        int failCount = updateToFailList.size();
        int successCount = updateToSuccessList.size();
        String repairResult = failCount > 0 ? InspectionRepairResult.FAILED.getNumber() : InspectionRepairResult.REPAIRED.getNumber();
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_inspect_log_cons set frepairresult=?  where freportdataid=?", updateToSuccessList, (t, d) -> {
            d.add(InspectionRepairResult.REPAIRED.getNumber());
            d.add(t);
        });
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_inspect_log_cons set frepairresult=?  where freportdataid=?", updateToFailList, (t, d) -> {
            d.add(InspectionRepairResult.FAILED.getNumber());
            d.add(t);
        });
        this.dataSaveService.updateAndCheckResult(IDataSaveService.Constants.INSPECTION_LOG_REPAIR_RESULT_UPDATE, Collections.singletonList(inspectionLogId), (t, d) -> {
            d.add(repairResult);
            d.add(t);
        });
        this.repairRecord.setFailedCount(failCount);
        this.repairRecord.setSuccessCount(successCount);
        this.dataSaveService.saveEntryDataThrow(Collections.singletonList(this.repairRecord), repairContext.getInspectionLogId());
        return failCount <= 0;
    }
}

