/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.repair;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.InspectionTargetType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.inspection.ControlRepairInfo;
import kd.tmc.fpm.business.domain.model.inspection.log.RepairRecord;
import kd.tmc.fpm.business.domain.model.inspection.log.RepairRecordDetail;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.IControlExecuteManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.impl.ActualUpdateCheckPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ControlExecuteManagerImpl;
import kd.tmc.fpm.business.mvc.service.inspection.context.RepairContext;
import kd.tmc.fpm.business.mvc.service.inspection.repair.IInspectDataRepair;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.service.rpc.helper.GenerateControlExecLogParamHelper;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.collections4.MapUtils;

public class BillComparisonDataRepairService
implements IInspectDataRepair {
    private static final Log logger = LogFactory.getLog(BillComparisonDataRepairService.class);
    private IDataSaveService dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
    private IControlExecuteManager controlExecuteManager = new ControlExecuteManagerImpl();
    private RepairRecord repairRecord;
    private List<RepairRecordDetail> repairRecordDetailList;
    private Map<Long, String> errorBillIdNoMap;

    public BillComparisonDataRepairService() {
        this.initRepairInfo();
    }

    private void initRepairInfo() {
        this.repairRecord = new RepairRecord();
        this.repairRecord.setId(DB.genGlobalLongId());
        this.repairRecord.setRepairDate(new Date());
        this.repairRecord.setExecuteMan(RequestContext.get().getCurrUserId());
        this.repairRecordDetailList = new ArrayList<RepairRecordDetail>(16);
        this.errorBillIdNoMap = new HashMap<Long, String>(16);
    }

    @Override
    public FpmOperateResult<Object> inspectDataRepair(RepairContext repairContext) {
        List<ControlRepairInfo> controlRepairInfoList = repairContext.getControlRepairInfoList();
        if (EmptyUtil.isEmpty(controlRepairInfoList)) {
            return FpmOperateResult.success();
        }
        ArrayList<String> messageList = new ArrayList<String>(16);
        for (ControlRepairInfo controlRepairInfo : controlRepairInfoList) {
            FpmOperateResult result;
            if (controlRepairInfo.getInspectionTargetType() == InspectionTargetType.INSPECT_BUSINESS_TRACE || (result = CommonUtils.processInTransactionRequiresNew(() -> {
                this.doRepair(controlRepairInfo, repairContext.getSystem());
                return FpmOperateResult.success();
            })).isSuccess()) continue;
            messageList.addAll(result.getMessageList());
        }
        if (EmptyUtil.isNoEmpty(messageList)) {
            logger.warn(String.join((CharSequence)"\r\n", messageList));
        }
        this.repairRecord.setFailedBills(StringHelper.subString((String)String.join((CharSequence)",", this.errorBillIdNoMap.values()), (int)1000));
        FpmOperateResult<Object> result = CommonUtils.processInTransactionRequiresNew(() -> {
            this.dataSaveService.saveEntryDataThrow(Collections.singletonList(this.repairRecord), repairContext.getInspectionLogId());
            this.dataSaveService.saveEntryDataThrow(this.repairRecordDetailList, repairContext.getInspectionLogId());
            return FpmOperateResult.success();
        });
        FpmAssertUtil.isTrue((boolean)result.isSuccess(), (String)String.join((CharSequence)";", result.getMessageList()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRepair(ControlRepairInfo controlRepairInfo, FundPlanSystem system) {
        List<ControlRepairInfo.LogBillInfo> logBillInfoList = controlRepairInfo.getLogBillInfoList();
        Set billIds = logBillInfoList.stream().map(ControlRepairInfo.LogBillInfo::getBillId).collect(Collectors.toSet());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)controlRepairInfo.getEntityType());
        DynamicObject[] load = TmcDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)dataEntityType);
        Map<Long, String> billIdNumberMap = Arrays.stream(load).collect(Collectors.toMap(dy -> (Long)dy.getPkValue(), dy -> dy.getString("billno"), (a, b) -> a));
        ControlContext controlContext = this.getControlContext(controlRepairInfo);
        List<ControlExcuteServiceLogParamDTO> executeServiceLogParamDTOList = GenerateControlExecLogParamHelper.generatePlanExecuteRecordParamsOfWrite(load, controlContext);
        executeServiceLogParamDTOList.removeIf(item -> !Objects.equals(system.getId(), item.getMatchRule().getSystemId()));
        Map<Long, Long> billMatchRuleIdMap = executeServiceLogParamDTOList.stream().collect(Collectors.toMap(p -> p.getBillBizInfo().getBillId(), p -> p.getMatchRule().getId(), (a, b) -> a));
        ControlResult result = this.doRepair(controlContext, executeServiceLogParamDTOList, controlRepairInfo);
        List<Long> successIdList = CommonUtils.getValueOrDefault(result.getSuccessIdList(), Collections.emptyList());
        logger.info("\u5de1\u68c0\u4fee\u590d\uff1a{}\uff0c\u5de1\u68c0\u76ee\u6807\uff1a{},\u4e1a\u52a1\u5355\u636e\u7c7b\u578b:{},\u9884\u5904\u7406\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u51c6\u5907\u6ce8\u518c\u6700\u7ec8\u4e00\u81f4\u6027\u670d\u52a1\u3002\u3002\u3002", new Object[]{controlRepairInfo.getLogDetailEntryId(), controlRepairInfo.getInspectionTargetType().getDescription(), controlRepairInfo.getEntityType()});
        try {
            if (EmptyUtil.isNoEmpty(successIdList)) {
                this.updateLogStatus(controlRepairInfo, successIdList);
                this.controlExecuteManager.commit(successIdList);
            }
        }
        catch (Throwable throwable) {
            TX.addCommitListener((CommitListener)new CommitListener(successIdList){
                final /* synthetic */ List val$successIdList;
                {
                    this.val$successIdList = list;
                }

                public void onRollbacked() {
                    logger.info("\u9884\u5904\u7406\u6b65\u9aa4\u6267\u884c\u5931\u8d25\uff0c\u51c6\u5907\u56de\u6eda:{}\u3002\u3002\u3002\u3002", (Object)this.val$successIdList);
                    try (TXHandle txHandle = TX.requiresNew();){
                        if (EmptyUtil.isNoEmpty((Object)this.val$successIdList)) {
                            BillComparisonDataRepairService.this.controlExecuteManager.rollback(this.val$successIdList);
                        }
                    }
                }
            });
            TX.addCommitListener((CommitListener)new CommitListener(result, controlRepairInfo, billIdNumberMap, billMatchRuleIdMap){
                final /* synthetic */ ControlResult val$result;
                final /* synthetic */ ControlRepairInfo val$controlRepairInfo;
                final /* synthetic */ Map val$billIdNumberMap;
                final /* synthetic */ Map val$billMatchRuleIdMap;
                {
                    this.val$result = controlResult;
                    this.val$controlRepairInfo = controlRepairInfo;
                    this.val$billIdNumberMap = map;
                    this.val$billMatchRuleIdMap = map2;
                }

                public void onCommitted() {
                    Map<Long, Set<Long>> failedBillIdExecuteRecordIdsMap = this.val$result.getFailedBillIdExecuteRecordIdsMap();
                    BillComparisonDataRepairService.this.fillRepairDetailInfo(failedBillIdExecuteRecordIdsMap, this.val$controlRepairInfo, this.val$billIdNumberMap, this.val$billMatchRuleIdMap, false);
                    Map<Long, Set<Long>> successBillIdExecuteRecordIdsMap = this.val$result.getSuccessBillIdExecuteRecordIdsMap();
                    BillComparisonDataRepairService.this.fillRepairDetailInfo(successBillIdExecuteRecordIdsMap, this.val$controlRepairInfo, this.val$billIdNumberMap, this.val$billMatchRuleIdMap, true);
                    BillComparisonDataRepairService.this.fillRepairDetailInfoForErrorMsg(this.val$result, this.val$controlRepairInfo, this.val$billMatchRuleIdMap, this.val$billIdNumberMap);
                }
            });
            throw throwable;
        }
        TX.addCommitListener((CommitListener)new /* invalid duplicate definition of identical inner class */);
        TX.addCommitListener((CommitListener)new /* invalid duplicate definition of identical inner class */);
    }

    private ControlResult doRepair(ControlContext controlContext, List<ControlExcuteServiceLogParamDTO> executeServiceLogParamDTOList, ControlRepairInfo controlRepairInfo) {
        ControlResult controlResult;
        ArrayList<ControlRepairInfo.LogBillInfo> logBillInfoList = new ArrayList<ControlRepairInfo.LogBillInfo>(controlRepairInfo.getLogBillInfoList());
        HashMap errorMsgMap = new HashMap(logBillInfoList.size());
        Set billIds = executeServiceLogParamDTOList.stream().map(ControlExcuteServiceLogParamDTO::getBillBizInfo).map(BillBizInfo::getBillId).collect(Collectors.toSet());
        logBillInfoList.removeIf(billInfo -> billIds.contains(billInfo.getBillId()));
        logBillInfoList.forEach(billInfo -> errorMsgMap.put(billInfo.getBillId(), ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"BillComparisonDataRepairService_0", (String)"tmc-fpm-business", (Object[])new Object[0])));
        IControlExecuteManager executeManager = FpmServiceFactory.getBizService(IControlExecuteManager.class);
        try {
            controlResult = executeManager.prepare(controlContext, executeServiceLogParamDTOList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            controlResult = new ControlResult();
            controlResult.setErrMsg(e.getMessage());
        }
        this.markFailedIfConfigIsError(controlContext, executeServiceLogParamDTOList, controlResult);
        for (Map.Entry entry : errorMsgMap.entrySet()) {
            controlResult.addErrMsg((Long)entry.getKey(), (String)entry.getValue());
        }
        return controlResult;
    }

    private void fillRepairDetailInfoForErrorMsg(ControlResult controlResult, ControlRepairInfo controlRepairInfo, Map<Long, Long> billMatchRuleIdMap, Map<Long, String> billIdNumberMap) {
        Map<Long, String> errIdMsgInfo = controlResult.getErrIdMsgInfo();
        Deque<Long> ids = CommonUtils.batchGenerateIds(errIdMsgInfo.size());
        errIdMsgInfo.forEach((billId, msg) -> {
            RepairRecordDetail repairRecordDetail = new RepairRecordDetail();
            repairRecordDetail.setId((Long)ids.poll());
            repairRecordDetail.setRepairId(this.repairRecord.getId());
            repairRecordDetail.setBillId((Long)billId);
            repairRecordDetail.setEntityType(controlRepairInfo.getEntityType());
            repairRecordDetail.setSuccessFlag(false);
            repairRecordDetail.setExecuteRecordId(0L);
            repairRecordDetail.setMatchRuleId(billMatchRuleIdMap.getOrDefault(billId, 0L));
            repairRecordDetail.setFailedReason((String)msg);
            this.repairRecordDetailList.add(repairRecordDetail);
            this.repairRecord.addCount(false);
            String billNo = billIdNumberMap.getOrDefault(billId, "");
            this.errorBillIdNoMap.putIfAbsent((Long)billId, billNo);
        });
    }

    private void markFailedIfConfigIsError(ControlContext controlContext, List<ControlExcuteServiceLogParamDTO> executeServiceLogParamDTOList, ControlResult controlResult) {
        List<ControlExecuteParam> controlExecuteParamList = controlContext.getControlExecuteParamList();
        if (controlExecuteParamList.size() == executeServiceLogParamDTOList.size()) {
            this.doFillErrorMsgIfNeed(executeServiceLogParamDTOList, controlResult);
            return;
        }
        Set uniqueIds = controlExecuteParamList.stream().map(ControlExecuteParam::getUniqueId).collect(Collectors.toSet());
        List<ControlExcuteServiceLogParamDTO> controlExecuteServiceLogParamDTOList = executeServiceLogParamDTOList.stream().filter(p -> !uniqueIds.contains(p.getUniqueId())).collect(Collectors.toList());
        controlExecuteServiceLogParamDTOList.forEach(p -> controlResult.addErrMsg(p.getBillBizInfo().getBillId(), ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"BillComparisonDataRepairService_0", (String)"tmc-fpm-business", (Object[])new Object[0])));
        executeServiceLogParamDTOList.removeAll(controlExecuteServiceLogParamDTOList);
        this.doFillErrorMsgIfNeed(executeServiceLogParamDTOList, controlResult);
    }

    private void doFillErrorMsgIfNeed(List<ControlExcuteServiceLogParamDTO> executeServiceLogParamDTOList, ControlResult controlResult) {
        if (controlResult.isFailed() && EmptyUtil.isNoEmpty((String)controlResult.getErrMsg())) {
            executeServiceLogParamDTOList.stream().map(ControlExcuteServiceLogParamDTO::getBillBizInfo).distinct().forEach(billBizInfo -> controlResult.addErrMsg(billBizInfo.getBillId(), controlResult.getErrMsg()));
        }
    }

    private void fillRepairDetailInfo(Map<Long, Set<Long>> failedBillIdExecuteRecordIdsMap, ControlRepairInfo controlRepairInfo, Map<Long, String> billIdNumberMap, Map<Long, Long> billMatchRuleIdMap, boolean isSuccess) {
        if (MapUtils.isEmpty(failedBillIdExecuteRecordIdsMap)) {
            return;
        }
        int count = failedBillIdExecuteRecordIdsMap.values().stream().mapToInt(Set::size).sum();
        Deque<Long> ids = CommonUtils.batchGenerateIds(count);
        failedBillIdExecuteRecordIdsMap.forEach((billId, recordIds) -> {
            for (Long recordId : recordIds) {
                RepairRecordDetail repairRecordDetail = new RepairRecordDetail();
                repairRecordDetail.setId((Long)ids.poll());
                repairRecordDetail.setRepairId(this.repairRecord.getId());
                repairRecordDetail.setBillId((Long)billId);
                repairRecordDetail.setEntityType(controlRepairInfo.getEntityType());
                repairRecordDetail.setSuccessFlag(isSuccess);
                repairRecordDetail.setExecuteRecordId(recordId);
                repairRecordDetail.setMatchRuleId(billMatchRuleIdMap.getOrDefault(billId, 0L));
                this.repairRecordDetailList.add(repairRecordDetail);
                this.repairRecord.addCount(isSuccess);
            }
            if (isSuccess && !this.errorBillIdNoMap.containsKey(billId)) {
                return;
            }
            String billNo = billIdNumberMap.getOrDefault(billId, "");
            this.errorBillIdNoMap.putIfAbsent((Long)billId, billNo);
        });
    }

    private void updateLogStatus(ControlRepairInfo controlRepairInfo, List<Long> successIdList) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_executeplan", (String)"bizbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", successIdList)});
        Set ids = query.stream().map(dy -> dy.getLong("bizbillid")).collect(Collectors.toSet());
        List logBillInfoList = controlRepairInfo.getLogBillInfoList().stream().filter(logBillInfo -> ids.contains(logBillInfo.getBillId())).collect(Collectors.toList());
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_log_bizbillerror set frepairresult='REPAIRED' where fentryid=?", logBillInfoList, (t, d) -> d.add(t.getBillEntryId()));
        QFilter qFilter = new QFilter(String.join((CharSequence)".", "entry_error_bizinfo", "a_resultentryid"), "=", (Object)controlRepairInfo.getLogDetailEntryId()).and(String.join((CharSequence)".", "entry_error_bizinfo", "a_repairresult"), "=", (Object)InspectionRepairResult.PENDING.getNumber());
        boolean exists = QueryServiceHelper.exists((String)"fpm_inspection_log", (QFilter[])new QFilter[]{qFilter});
        if (!exists) {
            this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_inspect_log_detail set frepairresult='REPAIRED' where fentryid=?", Collections.singletonList(controlRepairInfo.getLogDetailEntryId()), (t, d) -> d.add(t));
        }
    }

    private ControlContext getControlContext(ControlRepairInfo controlRepairInfo) {
        ControlContext controlContext = new ControlContext();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)controlRepairInfo.getEntityType());
        controlContext.setDbRouteKey(dataEntityType.getDBRouteKey());
        controlContext.setOpName("inspect-repair");
        controlContext.setOpCode("inspect-repair");
        controlContext.setPlanExecuteOpType(ITypeEnum.getByNumber(controlRepairInfo.getInspectionTargetType().getValue(), PlanExecuteOpType.class));
        controlContext.addControlExecuteParamPostProcessor(new ActualUpdateCheckPostProcessor());
        return controlContext;
    }
}

