/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.repair;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.service.IControlExecuteManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.inspection.context.RepairContext;
import kd.tmc.fpm.business.mvc.service.inspection.repair.IInspectDataRepair;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import org.apache.commons.collections.CollectionUtils;

public class BillNotExistDataRepairService
implements IInspectDataRepair {
    private static final Log logger = LogFactory.getLog(BillNotExistDataRepairService.class);
    private final IDataSaveService dataSaveService;
    private final IControlRepository controlRepository = FpmServiceFactory.getBizService(IControlRepository.class);
    private final IControlExecuteManager controlExecuteManager;

    public BillNotExistDataRepairService() {
        this.dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
        this.controlExecuteManager = FpmServiceFactory.getBizService(IControlExecuteManager.class);
    }

    @Override
    public FpmOperateResult<Object> inspectDataRepair(RepairContext repairContext) {
        return CommonUtils.processInTransactionRequiresNew(() -> {
            this.doRepair(repairContext);
            return FpmOperateResult.success();
        });
    }

    private void doRepair(RepairContext repairContext) {
        logger.info("[BillNotExistDataRepairService] >>>>> \u5f00\u59cb\u6267\u884c\u6570\u636e\u4fee\u590d\uff0c\u65e5\u5fd7id\uff1a[{}]", (Object)repairContext.getInspectionLogId());
        List<Long> execRecordIdList = repairContext.getExecRecordIdList();
        List<PlanExecuteRecord> planExecuteRecordList = this.controlRepository.loadPlanExecuteRecords(execRecordIdList);
        this.repairExecRecord(planExecuteRecordList, repairContext);
        logger.info("[BillNotExistDataRepairService] >>>>> \u5904\u7406\u88ab\u91ca\u653e\u7684\u9884\u5360\u6267\u884c\u8bb0\u5f55");
        List<Long> actualOccupyIdList = planExecuteRecordList.stream().filter(planExecuteRecord -> planExecuteRecord.getExecuteOpType() == PlanExecuteOpType.WRITE).map(PlanExecuteRecord::getId).collect(Collectors.toList());
        this.handlePreOccupyRecord(actualOccupyIdList, repairContext);
        logger.info("[BillNotExistDataRepairService] >>>>> \u6267\u884c\u4fee\u590d\u5b8c\u6210");
    }

    private void handlePreOccupyRecord(List<Long> actualOccupyIdList, RepairContext repairContext) {
        DynamicObjectCollection releaseRecords = QueryServiceHelper.query((String)"fpm_executeplan", (String)"originalrecordid", (QFilter[])new QFilter[]{new QFilter("relaterecordid", "in", actualOccupyIdList)});
        if (CollectionUtils.isEmpty((Collection)releaseRecords)) {
            return;
        }
        List<Long> originRecordIdList = releaseRecords.stream().map(releaseRecord -> releaseRecord.getLong("originalrecordid")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(originRecordIdList)) {
            return;
        }
        List<PlanExecuteRecord> planExecuteRecordList = this.controlRepository.loadPlanExecuteRecords(originRecordIdList);
        this.repairExecRecord(planExecuteRecordList, repairContext);
    }

    private void repairExecRecord(List<PlanExecuteRecord> planExecuteRecordList, RepairContext repairContext) {
        List<Long> deletedExecRecordIdList = planExecuteRecordList.stream().filter(PlanExecuteRecord::getDeleteStatus).map(PlanExecuteRecord::getId).collect(Collectors.toList());
        this.updateStatus(repairContext.getInspectionLogId(), deletedExecRecordIdList);
        logger.info("[BillNotExistDataRepairService] >>>>> \u4fee\u6539\u5df2\u7ecf\u88ab\u5220\u9664\u7684\u6267\u884c\u8bb0\u5f55\u7684\u4fee\u590d\u72b6\u6001\uff0c\u5171{}\u6761", (Object)deletedExecRecordIdList.size());
        planExecuteRecordList.removeIf(PlanExecuteRecord::getDeleteStatus);
        if (CollectionUtils.isEmpty(planExecuteRecordList)) {
            logger.info("[BillNotExistDataRepairService] >>>>> \u6392\u9664\u88ab\u5220\u9664\u7684\u6267\u884c\u8bb0\u5f55\u540e\u6ca1\u6709\u5f85\u4fee\u590d\u7684\u6267\u884c\u8bb0\u5f55\uff0c\u6267\u884c\u4fee\u590d\u5b8c\u6210\uff0c\u65e5\u5fd7id\uff1a[{}]", (Object)repairContext.getInspectionLogId());
            return;
        }
        logger.info("[BillNotExistDataRepairService] >>>>> \u5f85\u4fee\u590d\u7684\u6267\u884c\u8bb0\u5f55:[{}]", planExecuteRecordList.stream().map(PlanExecuteRecord::getId).collect(Collectors.toList()));
        Set matchRuleIdSet = planExecuteRecordList.stream().map(PlanExecuteRecord::getMatchRuleId).collect(Collectors.toSet());
        List<BillMatchRule> billMatchRules = this.controlRepository.loadBillMatchRule(new ArrayList<Long>(matchRuleIdSet));
        Map matchRuleMap = billMatchRules.stream().collect(Collectors.toMap(BillMatchRule::getId, Function.identity(), (k1, k2) -> k1));
        Map<String, List<PlanExecuteRecord>> planExecuteRecordMap = planExecuteRecordList.stream().collect(Collectors.groupingBy(p -> p.getBillBizInfo().getEntityType() + ":" + p.getExecuteOpType().getNumber()));
        List<ControlTime> controlTimes = this.controlRepository.loadControlTime(repairContext.getSystem().getId(), true);
        for (Map.Entry<String, List<PlanExecuteRecord>> entry : planExecuteRecordMap.entrySet()) {
            String[] key = entry.getKey().split(":");
            String entityType = key[0];
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
            String dbRouteKey = dataEntityType.getDBRouteKey();
            List<PlanExecuteRecord> planExecuteRecords = entry.getValue();
            PlanExecuteOpType executeOpType = planExecuteRecords.get(0).getExecuteOpType();
            PlanExecuteOpType oppositeOpType = executeOpType == PlanExecuteOpType.WRITE ? PlanExecuteOpType.CANCEL : PlanExecuteOpType.PRE_OCCUPY_DELETE;
            ArrayList<ControlExcuteServiceLogParamDTO> controlExcuteServiceLogParamDTOList = new ArrayList<ControlExcuteServiceLogParamDTO>(planExecuteRecords.size());
            for (PlanExecuteRecord planExecuteRecord : planExecuteRecords) {
                BillMatchRule matchRule = (BillMatchRule)matchRuleMap.get(planExecuteRecord.getMatchRuleId());
                controlExcuteServiceLogParamDTOList.add(this.buildControlParam(planExecuteRecord, oppositeOpType, matchRule));
            }
            ControlContext controlContext = this.getControlContext(dbRouteKey, oppositeOpType, entityType);
            controlContext.addControlTimes(controlTimes);
            this.executeControl(controlContext, controlExcuteServiceLogParamDTOList, planExecuteRecords, repairContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeControl(ControlContext controlContext, List<ControlExcuteServiceLogParamDTO> controlExcuteServiceLogParamDTOList, List<PlanExecuteRecord> planExecuteRecords, RepairContext repairContext) {
        ControlResult controlResult = this.controlExecuteManager.prepare(controlContext, controlExcuteServiceLogParamDTOList);
        List<Long> successIdList = controlResult.getSuccessIdList();
        try {
            if (EmptyUtil.isNoEmpty(successIdList)) {
                this.controlExecuteManager.commit(successIdList);
                this.updateStatusBySuccessIdList(repairContext.getInspectionLogId(), successIdList);
            }
        }
        catch (Throwable throwable) {
            TX.addCommitListener((CommitListener)new CommitListener(planExecuteRecords, repairContext, successIdList){
                final /* synthetic */ List val$planExecuteRecords;
                final /* synthetic */ RepairContext val$repairContext;
                final /* synthetic */ List val$successIdList;
                {
                    this.val$planExecuteRecords = list;
                    this.val$repairContext = repairContext;
                    this.val$successIdList = list2;
                }

                public void onRollbacked() {
                    logger.info("[BillNotExistDataRepairService] >>>>> \u6267\u884c\u4fee\u590d\u5931\u8d25\uff0c\u51c6\u5907\u56de\u6eda\uff0c PlanExecRecordId List:[{}]\uff0c \u65e5\u5fd7id\uff1a[{}]", this.val$planExecuteRecords.stream().map(PlanExecuteRecord::getId).collect(Collectors.toList()), (Object)this.val$repairContext.getInspectionLogId());
                    try (TXHandle txHandle = TX.requiresNew();){
                        if (EmptyUtil.isNoEmpty((Object)this.val$successIdList)) {
                            BillNotExistDataRepairService.this.controlExecuteManager.rollback(this.val$successIdList);
                        }
                    }
                }
            });
            throw throwable;
        }
        TX.addCommitListener((CommitListener)new /* invalid duplicate definition of identical inner class */);
    }

    private ControlExcuteServiceLogParamDTO buildControlParam(PlanExecuteRecord planExecuteRecord, PlanExecuteOpType oppositeOpType, BillMatchRule matchRule) {
        BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
        ControlExcuteServiceLogParamDTO controlExcuteServiceLogParamDTO = new ControlExcuteServiceLogParamDTO();
        controlExcuteServiceLogParamDTO.setBillBizInfo(billBizInfo);
        controlExcuteServiceLogParamDTO.setBizOpName("inspect-repair");
        controlExcuteServiceLogParamDTO.setMatchRule(matchRule);
        controlExcuteServiceLogParamDTO.setOpAmount(planExecuteRecord.getActAmount());
        controlExcuteServiceLogParamDTO.setUniqueId(UUID.randomUUID().toString());
        controlExcuteServiceLogParamDTO.setServiceType(oppositeOpType);
        return controlExcuteServiceLogParamDTO;
    }

    private void updateStatusBySuccessIdList(Long logId, List<Long> successIdList) {
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_executeplan", (String)"originalrecordid", (QFilter[])new QFilter[]{new QFilter("id", "in", successIdList)});
        Set originExecRecordIdList = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("originalrecordid")).collect(Collectors.toSet());
        this.updateStatus(logId, new ArrayList<Long>(originExecRecordIdList));
    }

    private void updateStatus(Long logId, List<Long> originExecRecordIdList) {
        logger.info("[BillNotExistDataRepairService] >>>>> Prepare to update Log Status, Log id:[{}], PlanExecRecord Id:[{}]", (Object)logId, originExecRecordIdList);
        ArrayList paramList = new ArrayList(originExecRecordIdList.size());
        for (Long execRecordId : originExecRecordIdList) {
            ArrayList<Long> params = new ArrayList<Long>(2);
            params.add(logId);
            params.add(execRecordId);
            paramList.add(params);
        }
        this.dataSaveService.update(IDataSaveService.Constants.INSPECTION_BILL_NOT_EXIST_LOG_ENTRY_REPAIR_RESULT_UPDATE, paramList, (t, d) -> {
            d.add(InspectionRepairResult.REPAIRED.getNumber());
            d.add(t.get(0));
            d.add(t.get(1));
        });
        String repairResultProp = String.join((CharSequence)".", "entry_exec_record", "e_exec_repairresult");
        String execRecordProp = String.join((CharSequence)".", "entry_exec_record", "e_exec_record");
        QFilter qFilter = new QFilter(repairResultProp, "=", (Object)InspectionRepairResult.PENDING.getNumber()).and(new QFilter("id", "=", (Object)logId));
        DynamicObjectCollection pendingRecords = QueryServiceHelper.query((String)"fpm_inspection_log", (String)execRecordProp, (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)pendingRecords)) {
            logger.info("[BillNotExistDataRepairService] >>>>> \u6240\u6709\u5f02\u5e38\u8bb0\u5f55\u90fd\u5df2\u4fee\u590d\uff0c\u5c06\u5355\u5934\u72b6\u6001\u6539\u4e3a\u5df2\u4fee\u590d\uff0c\u65e5\u5fd7Id:[{}]", (Object)logId);
            this.dataSaveService.update(IDataSaveService.Constants.INSPECTION_LOG_REPAIR_RESULT_UPDATE, Collections.singletonList(logId), (t, d) -> {
                d.add(InspectionRepairResult.REPAIRED.getNumber());
                d.add(t);
            });
        }
    }

    private ControlContext getControlContext(String dbRouteKey, PlanExecuteOpType planExecuteOpType, String entityType) {
        ControlContext controlContext = new ControlContext();
        controlContext.setDbRouteKey(dbRouteKey);
        controlContext.setOpName("inspect-repair");
        controlContext.setOpCode("inspect-repair");
        controlContext.setPlanExecuteOpType(planExecuteOpType);
        controlContext.setEntityType(entityType);
        return controlContext;
    }
}

