/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.strategy.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlResult;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.AbstractDataInspectStrategy;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.utils.NumberUtils;

public class ActualReleaseDataInspectStrategy
extends AbstractDataInspectStrategy {
    public ActualReleaseDataInspectStrategy(InspectContext inspectContext) {
        super(inspectContext);
    }

    @Override
    public InspectControlResult handler(InspectParam inspectParam) {
        InspectControlResult inspectControlResult = super.handler(inspectParam);
        List<BillBizInfo> billBizInfoList = inspectParam.getBillBizInfoList();
        logger.info("\u5b9e\u5360\u8fd4\u8fd8\u5de1\u68c0\u5f85\u5904\u7406\u4e1a\u52a1\u5355\u636e\u8bb0\u5f55\u6761\u6570\uff1a{}", (Object)billBizInfoList.size());
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        ControlTime controlTime = this.inspectContext.getControlTime();
        Optional<ControlActTime> first = controlTime.getControlActTimeList().stream().filter(t -> Objects.equals(t.getBizBill(), inspectParam.getEntityType())).filter(controlActTime -> EmptyUtil.isNoEmpty(controlActTime.getReleaseActTime())).findFirst();
        if (!first.isPresent()) {
            logger.warn("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{} \u672a\u914d\u7f6e\u6267\u884c\u65f6\u673a\u5b9e\u5360\u5206\u5f55\u914d\u7f6e", (Object)inspectParam.getEntityType());
            return inspectControlResult;
        }
        ControlActTime controlActTime2 = first.get();
        String factBackAmtField = controlActTime2.getFactBackAmtField();
        if (EmptyUtil.isEmpty((String)factBackAmtField)) {
            logger.warn("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{} \u672a\u914d\u7f6e\u5b9e\u5360\u8fd4\u8fd8\u5b57\u6bb5", (Object)inspectParam.getEntityType());
            return inspectControlResult;
        }
        for (BillBizInfo billBizInfo : billBizInfoList) {
            List<PlanExecuteRecord> actualPlanExecuteRecordList;
            if (inspectControlResult.isError(billBizInfo) || EmptyUtil.isEmpty(actualPlanExecuteRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.WRITE))) continue;
            List<PlanExecuteRecord> planExecuteRecordByOp = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.RELEASE);
            if (EmptyUtil.isEmpty(planExecuteRecordByOp)) {
                List<PlanExecuteRecord> actualUpdatePlanExecuteRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.UPDATE);
                Map<Long, List<PlanExecuteRecord>> originalListMap = actualUpdatePlanExecuteRecordList.stream().collect(Collectors.groupingBy(PlanExecuteRecord::getOriginalRecordId));
                Optional<PlanExecuteRecord> any = actualPlanExecuteRecordList.stream().filter(p -> EmptyUtil.isEmpty((Collection)((Collection)originalListMap.get(p.getId()))) ? p.isNotAllRelease() : p.isNotAllReleaseForActual()).findAny();
                if (!any.isPresent()) continue;
                inspectControlResult.addBillBizInfo(billBizInfo);
                continue;
            }
            Optional<BizProps> bizPropsOptional = billBizInfo.getBizProps().stream().filter(bizProps -> Objects.equals(bizProps.getBizProp(), factBackAmtField)).findFirst();
            if (!bizPropsOptional.isPresent()) {
                logger.warn("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}\uff0c\u6267\u884c\u59cb\u7ec8\u4e2d\u914d\u7f6e\u7684\u8fd4\u8fd8\u5b57\u6bb5\uff1a{}\u672a\u5339\u914d\u4e0a", (Object)billBizInfo.getEntityType(), (Object)factBackAmtField);
                continue;
            }
            planExecuteRecordByOp.sort(Comparator.comparing(PlanExecuteRecord::getCreateTime).reversed());
            PlanExecuteRecord planExecuteRecord = planExecuteRecordByOp.get(0);
            BigDecimal actAmount = planExecuteRecord.getActAmount().negate();
            BigDecimal bigDecimalValue = CommonUtils.getBigDecimalValue(bizPropsOptional.get().getValue());
            if (NumberUtils.equals((BigDecimal)actAmount, (BigDecimal)bigDecimalValue)) continue;
            inspectControlResult.addBillBizInfo(billBizInfo);
        }
        return inspectControlResult;
    }
}

