/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.strategy.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlResult;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.AbstractDataInspectStrategy;

public class OccupyReleaseDataInspectStrategy
extends AbstractDataInspectStrategy {
    public OccupyReleaseDataInspectStrategy(InspectContext inspectContext) {
        super(inspectContext);
    }

    @Override
    public InspectControlResult handler(InspectParam inspectParam) {
        InspectControlResult inspectControlResult = super.handler(inspectParam);
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = this.inspectContext.getBusinessBillExecuteRecordInfo();
        ControlTime controlTime = this.inspectContext.getControlTime();
        HashSet<Long> reportTypeIds = new HashSet<Long>(controlTime.getControledReportTypeIds());
        List<BillBizInfo> billBizInfoList = inspectParam.getBillBizInfoList();
        logger.info("\u9884\u5360\u91ca\u653e\u5de1\u68c0\u5f85\u5904\u7406\u4e1a\u52a1\u5355\u636e\u8bb0\u5f55\u6761\u6570\uff1a{}", (Object)billBizInfoList.size());
        for (BillBizInfo billBizInfo : billBizInfoList) {
            List<ControlBOTPInfo> downBillBizInfoList;
            Optional<PlanExecuteRecord> any;
            List<PlanExecuteRecord> planExecuteRecordList;
            if (inspectControlResult.isError(billBizInfo) || EmptyUtil.isEmpty(planExecuteRecordList = businessBillExecuteRecordInfo.getPlanExecuteRecordByOp(billBizInfo, PlanExecuteOpType.PRE_OCCUPY_WRITE)) || !(any = planExecuteRecordList.stream().filter(p -> EmptyUtil.isEmpty((Collection)reportTypeIds) || reportTypeIds.contains(p.getReportTypeId())).filter(PlanExecuteRecord::isNotAllRelease).findAny()).isPresent() || EmptyUtil.isNoEmpty(downBillBizInfoList = businessBillExecuteRecordInfo.getDownBillBizInfoList(billBizInfo.getBillId()))) continue;
            inspectControlResult.addBillBizInfo(billBizInfo);
        }
        return inspectControlResult;
    }
}

