/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.interior.offset.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQParam;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.interior.offset.InnerCancelInfo;
import kd.tmc.fpm.business.domain.model.interior.offset.InternalOffsetQResult;
import kd.tmc.fpm.business.domain.model.interior.offset.InternalOffsetQueryParam;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.service.interior.offset.IInternalOffsetService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DataSetUtil;

public class InternalOffsetServiceImpl
implements IInternalOffsetService {
    private static final Log logger = LogFactory.getLog(InternalOffsetServiceImpl.class);
    private final IDimensionRepository iDimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private final IReportDataQueryService iReportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);

    @Override
    public FpmOperateResult<List<InternalOffsetQResult>> queryInternalOffsetData(InternalOffsetQueryParam queryParam) {
        List<InternalOffsetQResult> internalOffsetQResults;
        if (Objects.isNull(queryParam) || Objects.isNull(queryParam.getSystemId())) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InternalOffsetServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        try {
            List<ReportDataQueryResult> reportDataQueryResultList = this.getReportDataQueryResults(queryParam);
            internalOffsetQResults = reportDataQueryResultList.stream().map(this::initInternalOffsetQResult).collect(Collectors.toList());
            this.setInnerCancelInfo(internalOffsetQResults);
        }
        catch (KDBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return FpmOperateResult.error(e.getMessage());
        }
        return FpmOperateResult.success(internalOffsetQResults);
    }

    private List<ReportDataQueryResult> getReportDataQueryResults(InternalOffsetQueryParam queryParam) {
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        queryObject.setDimValList(queryParam.getDimValList());
        queryObject.setResource("openApi");
        queryObject.setQueryDetail(Boolean.FALSE);
        List<ReportDataQParam.DimBaseInfo> dimIdList = queryParam.getDimIdList();
        if (EmptyUtil.isNoEmpty(dimIdList)) {
            Optional<ReportDataQParam.DimBaseInfo> illegalDim = dimIdList.stream().filter(item -> item.getDimType() != DimensionType.ORG).filter(item -> item.getDimType() != DimensionType.CURRENCY).filter(item -> item.getDimType() != DimensionType.PERIOD).filter(item -> item.getDimType() != DimensionType.SUBJECTS).filter(item -> item.getDimType() != DimensionType.SETTLEMENT_TYPE).filter(item -> item.getDimType() != DimensionType.COMPANY).filter(item -> item.getDimType() != DimensionType.CUSTOM).findAny();
            if (illegalDim.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u53c2\u6570", (String)"InternalOffsetServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            FundPlanSystem system = this.iDimensionRepository.loadSystem(queryParam.getSystemId());
            List<Dimension> systemDimList = system.getDimList();
            ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(dimIdList.size());
            for (ReportDataQParam.DimBaseInfo dimension : dimIdList) {
                Optional<Dimension> first = systemDimList.stream().filter(item -> item.getDimType() == dimension.getDimType() && item.getId().equals(dimension.getId())).findAny();
                if (!first.isPresent()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u4f53\u7cfb\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6", (String)"InternalOffsetServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
                }
                dimensionList.add(first.get());
            }
            queryObject.setDimIdList(dimensionList);
        }
        return this.iReportDataQueryService.queryReportData(queryObject);
    }

    private InternalOffsetQResult initInternalOffsetQResult(ReportDataQueryResult reportData) {
        InternalOffsetQResult internalOffsetQResult = new InternalOffsetQResult();
        internalOffsetQResult.setId(reportData.getId());
        internalOffsetQResult.setReportId(reportData.getReportId());
        internalOffsetQResult.setDimIdList(reportData.getDimIdList());
        internalOffsetQResult.setDimList(reportData.getDimList());
        internalOffsetQResult.setDimValList(reportData.getDimValList());
        return internalOffsetQResult;
    }

    private void setInnerCancelInfo(List<InternalOffsetQResult> internalOffsetQResults) {
        if (EmptyUtil.isEmpty(internalOffsetQResults)) {
            return;
        }
        List reportDataIds = internalOffsetQResults.stream().map(InternalOffsetQResult::getId).collect(Collectors.toList());
        Set reportIds = internalOffsetQResults.stream().map(InternalOffsetQResult::getReportId).collect(Collectors.toSet());
        String cancelEntryReportDataIdProperty = String.join((CharSequence)".", "entryentity", "reportdataid");
        QFilter qFilter = new QFilter(String.join((CharSequence)".", "entryentity", "reportid"), "in", reportIds).and(cancelEntryReportDataIdProperty, "in", reportDataIds);
        ArrayList innerCancelDetailProperties = new ArrayList(5);
        Collections.addAll(innerCancelDetailProperties, "id", "sumplanrecordid", cancelEntryReportDataIdProperty, String.join((CharSequence)".", "entryentity", "id"), String.join((CharSequence)".", "entryentity", "cancelamt"));
        String algoKey = String.join((CharSequence)".", this.getClass().getSimpleName(), "queryInnerCancelDetail");
        DataSet cancelDetailEntryDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fpm_innercancelrecord", (String)String.join((CharSequence)",", innerCancelDetailProperties), (QFilter[])qFilter.toArray(), (String)"");
        DataSet cancelDetailEntryDataSetCopy = cancelDetailEntryDataSet.copy();
        DataSet sumPlanRecordIdDataSet = cancelDetailEntryDataSetCopy.select("sumplanrecordid");
        HashSet<Long> sumPlanRecordIdSet = new HashSet<Long>(16);
        while (sumPlanRecordIdDataSet.hasNext()) {
            Row sumPlanRecordIdRow = sumPlanRecordIdDataSet.next();
            sumPlanRecordIdSet.add(sumPlanRecordIdRow.getLong("sumplanrecordid"));
        }
        if (EmptyUtil.isEmpty(sumPlanRecordIdSet)) {
            DataSetUtil.closeDataSet(cancelDetailEntryDataSet);
            return;
        }
        String sumPlanRecordAlgoKey = String.join((CharSequence)".", this.getClass().getSimpleName(), "querySumPlanRecord");
        DataSet sumPlanRecordDataSet = QueryServiceHelper.queryDataSet((String)sumPlanRecordAlgoKey, (String)"fpm_reportplansum", (String)String.join((CharSequence)",", "id", "reportorg", "amountunit"), (QFilter[])new QFilter[]{new QFilter("id", "in", sumPlanRecordIdSet)}, (String)"");
        ArrayList innerCancelInfoProperties = new ArrayList(6);
        innerCancelInfoProperties.addAll(innerCancelDetailProperties);
        innerCancelInfoProperties.add("reportorg");
        innerCancelInfoProperties.add("amountunit");
        DataSet resultDataSet = cancelDetailEntryDataSet.join(sumPlanRecordDataSet).on("sumplanrecordid", "id").select(innerCancelInfoProperties.toArray(new String[0])).finish();
        Map<Long, List<InnerCancelInfo>> innerCancelInfoMap = this.transferInnerCancelInfoMap(resultDataSet);
        internalOffsetQResults.forEach(qResult -> qResult.setInnerCancelInfoList(innerCancelInfoMap.getOrDefault(qResult.getId(), new ArrayList(0))));
        DataSetUtil.closeDataSet(cancelDetailEntryDataSet, cancelDetailEntryDataSetCopy, sumPlanRecordDataSet, resultDataSet);
    }

    private Map<Long, List<InnerCancelInfo>> transferInnerCancelInfoMap(DataSet innerCancelInfoDataSet) {
        HashMap<Long, List<InnerCancelInfo>> cancelInfoMap = new HashMap<Long, List<InnerCancelInfo>>(16);
        while (innerCancelInfoDataSet.hasNext()) {
            Row innerCancelInfoRow = innerCancelInfoDataSet.next();
            String cancelEntryReportDataIdProperty = String.join((CharSequence)".", "entryentity", "reportdataid");
            Long reportDataId = innerCancelInfoRow.getLong(cancelEntryReportDataIdProperty);
            InnerCancelInfo innerCancelInfo = new InnerCancelInfo();
            innerCancelInfo.setSumPlanRecordId(innerCancelInfoRow.getLong("sumplanrecordid"));
            innerCancelInfo.setSumOrgMemberId(innerCancelInfoRow.getLong("reportorg"));
            innerCancelInfo.setInnerCancelRecordId(innerCancelInfoRow.getLong("id"));
            innerCancelInfo.setInnerCancelDetailId(innerCancelInfoRow.getLong(String.join((CharSequence)".", "entryentity", "id")));
            innerCancelInfo.setOffsetAmt(innerCancelInfoRow.getBigDecimal(String.join((CharSequence)".", "entryentity", "cancelamt")));
            innerCancelInfo.setAmountUnit(AmountUnit.getByNumber(innerCancelInfoRow.getString("amountunit")));
            List innerCancelInfoList = cancelInfoMap.computeIfAbsent(reportDataId, key -> new ArrayList(5));
            innerCancelInfoList.add(innerCancelInfo);
        }
        return cancelInfoMap;
    }
}

