/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.lock;

import java.util.Objects;
import java.util.function.Supplier;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DLockService {
    private static final Log logger = LogFactory.getLog(DLockService.class);
    private final String dLockName;
    private DLock dLock;
    private boolean lockResult;
    private final boolean throwIfLockFailed;
    private final Supplier<String> errorMsgWhenLockFailed;

    public DLockService(String dLockName) {
        this(dLockName, null);
    }

    public DLockService(String dLockName, Supplier<String> errorMsgWhenLockFailed) {
        this(dLockName, Objects.nonNull(errorMsgWhenLockFailed), errorMsgWhenLockFailed);
    }

    public DLockService(String dLockName, boolean throwIfLockFailed, Supplier<String> errorMsgWhenLockFailed) {
        this.dLockName = dLockName;
        this.throwIfLockFailed = throwIfLockFailed;
        this.errorMsgWhenLockFailed = errorMsgWhenLockFailed;
    }

    public void tryLock() {
        logger.info("\u51c6\u5907\u5c1d\u8bd5\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)this.dLockName);
        this.initDLockIfNeed();
        this.lockResult = this.dLock.tryLock();
        this.checkAndThrow();
    }

    private void checkAndThrow() {
        if (this.lockResult) {
            logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff1a{}\u6210\u529f\u3002", (Object)this.dLockName);
            return;
        }
        if (this.throwIfLockFailed) {
            throw new KDBizException(this.errorMsgWhenLockFailed.get());
        }
    }

    public void tryLock(long duration) {
        logger.info("\u51c6\u5907\u5c1d\u8bd5\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)this.dLockName);
        this.initDLockIfNeed();
        this.lockResult = this.dLock.tryLock(duration);
        this.checkAndThrow();
    }

    public void unLock() {
        if (Objects.nonNull(this.dLock) && this.lockResult) {
            this.dLock.unlock();
        }
    }

    private void initDLockIfNeed() {
        if (Objects.isNull(this.dLock)) {
            this.dLock = DLock.create((String)this.dLockName);
        }
    }
}

