/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.controlmatch.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResultInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractControlMatch;

public class MainChildReportGroupControlMatch
extends AbstractControlMatch {
    @Override
    MatchResultInfo doMatch(MatchInfo matchInfo, List<GroupReportData> groupReportDataList) {
        ArrayList<GroupReportData> groupReportDataResultList = new ArrayList<GroupReportData>(groupReportDataList.size() * 2);
        for (GroupReportData groupReportData : groupReportDataList) {
            if (groupReportData.hasException()) {
                groupReportDataResultList.add(groupReportData);
                continue;
            }
            List<ReportData> reportDataList = groupReportData.getReportDataList();
            Map<Long, List<ReportData>> mainChildDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
            if (mainChildDataMap.size() <= 1) {
                groupReportDataResultList.add(groupReportData);
                continue;
            }
            Map<Long, List<ReportData>> mainChildOptionalDataMap = groupReportData.getOptionalReportDataList().stream().collect(Collectors.groupingBy(ReportData::getReportId));
            ReportData reportData = groupReportData.getReportData();
            for (Map.Entry<Long, List<ReportData>> entry : mainChildDataMap.entrySet()) {
                List<ReportData> dataList = entry.getValue();
                if (EmptyUtil.isEmpty(dataList)) continue;
                ReportData currentRd = dataList.get(0);
                GroupReportData copy = groupReportData.copy();
                copy.setReportDataList(dataList);
                copy.setOptionalReportDataList(mainChildOptionalDataMap.getOrDefault(entry.getKey(), Collections.emptyList()));
                if (Objects.nonNull(reportData) && Objects.equals(currentRd.getReportId(), reportData.getReportId())) {
                    copy.setReportData(reportData);
                }
                if (!currentRd.isMainTable() && groupReportData.isMatchedDetail()) {
                    copy.setDetailDimBitMap(groupReportData.getDetailDimBitMap());
                }
                groupReportDataResultList.add(copy);
            }
        }
        return this.success(groupReportDataResultList);
    }
}

