/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.controlmatch.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResultInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.helper.ReportPeriodHelper;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.impl.AbstractControlMatch;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class ReportOrgAndPeriodControlMatch
extends AbstractControlMatch {
    @Override
    MatchResultInfo doMatch(MatchInfo matchInfo, List<GroupReportData> groupReportDataList) {
        Set<Long> periodMemIds = matchInfo.getPeriodMemIds();
        FundPlanSystem fundPlanSystem = matchInfo.getFundPlanSystem();
        Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        if (EmptyUtil.isEmpty(periodMemIds)) {
            return this.error(new MatchException(matchInfo, periodDim));
        }
        Dimension orgDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG);
        ArrayList<GroupReportData> groupReportDataListResult = new ArrayList<GroupReportData>(16);
        for (GroupReportData groupReportData : groupReportDataList) {
            QueryIndexInfo<Long, ReportData> queryIndexInfo = groupReportData.getQueryIndexInfo(fundPlanSystem);
            HashSet<Long> sumReportOrgIds = new HashSet<Long>(matchInfo.getSumReportOrgIds());
            for (Long periodMemId : periodMemIds) {
                DimensionInfoBean copy = groupReportData.getDimensionInfoBean().copy();
                copy.addDimensionInfo(orgDim.getId(), (Object)matchInfo.getReportOrgId());
                copy.addDimensionInfo(periodDim.getId(), (Object)periodMemId);
                List<ReportData> reportDataList = queryIndexInfo.findList(copy);
                if (EmptyUtil.isEmpty(reportDataList)) continue;
                groupReportDataListResult.add(new GroupReportData(matchInfo.getReportOrgId(), periodMemId, copy, reportDataList));
                for (Long sumReportOrgId : sumReportOrgIds) {
                    DimensionInfoBean sumCopy = groupReportData.getDimensionInfoBean().copy();
                    sumCopy.addDimensionInfo(orgDim.getId(), (Object)sumReportOrgId);
                    sumCopy.addDimensionInfo(periodDim.getId(), (Object)periodMemId);
                    List<ReportData> sumReportDataList = queryIndexInfo.findList(sumCopy);
                    if (EmptyUtil.isEmpty(sumReportDataList)) continue;
                    GroupReportData sumGroupReportData = new GroupReportData(0L, periodMemId, sumCopy, sumReportDataList);
                    sumGroupReportData.setSumReportOrgId(sumReportOrgId);
                    groupReportDataListResult.add(sumGroupReportData);
                }
            }
        }
        if (EmptyUtil.isEmpty(groupReportDataListResult)) {
            List dimMemberList = periodDim.getAllDimMemberList().stream().filter(p -> matchInfo.getPeriodMemIds().contains(p.getId())).map(PeriodMember.class::cast).collect(Collectors.toList());
            PeriodMember periodMember = (PeriodMember)dimMemberList.get(0);
            ReportPeriodType reportType = fundPlanSystem.getReportTypeList().stream().filter(reportPeriodType -> Objects.equals(periodMember.getPeriodTypeId(), reportPeriodType.getReportPeriodId())).findFirst().get();
            String periodNames = dimMemberList.stream().filter(p -> ReportPeriodHelper.periodTypeEqual(reportType, p.getPeriodType())).map(DimMember::getName).collect(Collectors.joining(","));
            String msg = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%2$s\u3011\u4e1a\u52a1\u5355\u636e\u5bf9\u5e94\u7f16\u62a5\u4e3b\u4f53\u3010%3$s\u3011\u8ba1\u5212\u671f\u95f4\u3010%4$s\u3011\u65e0\u751f\u6548\u7684\u8d44\u91d1\u8ba1\u5212\uff0c\u8bf7\u68c0\u67e5\u8ba1\u5212\u7f16\u5236\u60c5\u51b5", (String)"ReportOrgAndPeriodControlMatch_0", (String)"tmc-fpm-business", (Object[])new Object[0]), fundPlanSystem.getName(), matchInfo.getMatchRule().getNumber(), orgDim.getDimMemberById(matchInfo.getReportOrgId()).getName(), periodNames);
            return this.error(new MatchException(matchInfo, msg, MatchException.MatchErrorType.MATCH_NO_DATA));
        }
        return this.success(groupReportDataListResult);
    }
}

