/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchParam;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.domain.model.match.MatchResultInfo;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.match.IControlMatchService;
import kd.tmc.fpm.business.mvc.service.match.controlmatch.IControlMatch;
import kd.tmc.fpm.business.mvc.service.match.generate.IMatchResultGenerator;
import kd.tmc.fpm.business.mvc.service.match.strategy.IControlMatchStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.impl.DefaultControlMatchStrategy;

public abstract class AbstractControlMatchService
implements IControlMatchService {
    protected static final Log logger = LogFactory.getLog(AbstractControlMatchService.class);
    private List<IControlMatch> controlMatchList;
    private IControlMatchStrategy controlMatchStrategy;
    private IMatchResultGenerator matchResultGenerator;

    public AbstractControlMatchService() {
        this(new DefaultControlMatchStrategy());
    }

    public AbstractControlMatchService(IControlMatchStrategy controlMatchStrategy) {
        this.controlMatchStrategy = controlMatchStrategy;
        this.controlMatchList = new ArrayList<IControlMatch>(8);
    }

    public AbstractControlMatchService addControlMatch(IControlMatch controlMatch) {
        if (!this.controlMatchList.contains(controlMatch)) {
            this.controlMatchList.add(controlMatch);
        }
        return this;
    }

    public AbstractControlMatchService setControlMatchStrategy(IControlMatchStrategy controlMatchStrategy) {
        this.controlMatchStrategy = controlMatchStrategy;
        return this;
    }

    public AbstractControlMatchService setMatchResultGenerator(IMatchResultGenerator matchResultGenerator) {
        this.matchResultGenerator = matchResultGenerator;
        return this;
    }

    @Override
    public FpmOperateResult<List<MatchResult>> match(List<MatchParam> matchParamList) {
        if (EmptyUtil.isEmpty(matchParamList)) {
            return FpmOperateResult.success(new ArrayList(1));
        }
        try {
            List<MatchInfo> matchInfoList = this.controlMatchStrategy.getMatchInfoList(matchParamList);
            List<GroupReportData> groupReportDataList = this.controlMatchStrategy.getGroupReportDataList(matchInfoList);
            return FpmOperateResult.success(this.doMatch(matchInfoList, groupReportDataList));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return FpmOperateResult.error(e.getMessage());
        }
    }

    protected List<MatchResult> doMatch(List<MatchInfo> matchInfoList, List<GroupReportData> groupReportDataList) {
        if (EmptyUtil.isEmpty(groupReportDataList)) {
            return Collections.emptyList();
        }
        ControlMatchChainNode controlMatchChain = this.getControlMatchChain();
        if (controlMatchChain == null) {
            return Collections.emptyList();
        }
        ArrayList<MatchResult> matchResultList = new ArrayList<MatchResult>(matchInfoList.size());
        for (MatchInfo matchInfo : matchInfoList) {
            MatchResultInfo matchResultInfo = controlMatchChain.match(matchInfo, groupReportDataList);
            matchResultList.addAll(this.matchResultGenerator.generate(matchInfo, matchResultInfo));
        }
        return matchResultList;
    }

    protected ControlMatchChainNode getControlMatchChain() {
        ControlMatchChainNode controlMatchChainNode = null;
        for (int i = this.controlMatchList.size() - 1; i >= 0; --i) {
            IControlMatch controlMatch = this.controlMatchList.get(i);
            controlMatchChainNode = new ControlMatchChainNode(controlMatch, controlMatchChainNode);
        }
        return controlMatchChainNode;
    }

    public static class ControlMatchChainNode
    implements IControlMatch {
        private IControlMatch controlMatch;
        private ControlMatchChainNode next;

        public ControlMatchChainNode(IControlMatch controlMatch) {
            this.controlMatch = controlMatch;
        }

        public ControlMatchChainNode(IControlMatch controlMatch, ControlMatchChainNode next) {
            this.controlMatch = controlMatch;
            this.next = next;
        }

        public ControlMatchChainNode addNext(IControlMatch controlMatch) {
            return this.addNext(new ControlMatchChainNode(controlMatch));
        }

        public ControlMatchChainNode addNext(ControlMatchChainNode controlMatchChainNode) {
            this.next = controlMatchChainNode;
            return controlMatchChainNode;
        }

        @Override
        public MatchResultInfo match(MatchInfo matchInfo, List<GroupReportData> groupReportDataList) {
            MatchResultInfo matchResultInfo = this.doMatch(matchInfo, groupReportDataList);
            if (matchResultInfo.hasException()) {
                return matchResultInfo;
            }
            if (EmptyUtil.isEmpty(matchResultInfo.getGroupReportDataList())) {
                return matchResultInfo;
            }
            if (Objects.nonNull(this.next)) {
                return this.next.match(matchInfo, matchResultInfo.getGroupReportDataList());
            }
            return matchResultInfo;
        }

        private MatchResultInfo doMatch(MatchInfo matchInfo, List<GroupReportData> groupReportDataList) {
            try {
                return this.controlMatch.match(matchInfo, groupReportDataList);
            }
            catch (MatchException e) {
                logger.error(e.getErrorMsg(), (Throwable)((Object)e));
                return MatchResultInfo.error(e);
            }
        }
    }
}

