/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.match.impl.AbstractDecorationControlMatchService;

public class ActualSubjectNotMatchedFilterControlMatchService
extends AbstractDecorationControlMatchService {
    public ActualSubjectNotMatchedFilterControlMatchService(AbstractDecorationControlMatchService controlMatchService) {
        super(controlMatchService);
    }

    @Override
    protected void doProcessMatchResults(List<MatchResult> matchResultList) {
        if (!this.controlContext.getPlanExecuteOpType().isWrite()) {
            return;
        }
        HashMap<String, MatchErrorInfo> matchErrorInfoMap = new HashMap<String, MatchErrorInfo>(16);
        for (MatchResult matchResult : matchResultList) {
            Dimension notMatchedDimension;
            Long reportTypeId = this.getReportTypeId(matchResult);
            if (EmptyUtil.isEmpty((Long)reportTypeId)) continue;
            String uniqueKey = matchResult.getUniqueKey();
            MatchErrorInfo matchErrorInfo = matchErrorInfoMap.computeIfAbsent(uniqueKey, MatchErrorInfo::new);
            if (matchResult.isSuccess()) {
                matchErrorInfo.markHasSuccess();
                continue;
            }
            MatchException matchException = matchResult.getMatchException();
            if (!matchException.getMatchErrorType().isMatchError() || (notMatchedDimension = matchException.getNotMatchedDimension()) == null || !notMatchedDimension.getDimType().isSubjectDim()) continue;
            matchErrorInfo.addMatchResult(matchResult);
        }
        List waitDeleteMatchResultList = matchErrorInfoMap.values().stream().filter(MatchErrorInfo::isHasSuccess).map(MatchErrorInfo::getWaitDeleteMatchResultList).flatMap(Collection::stream).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(waitDeleteMatchResultList)) {
            matchResultList.removeAll(waitDeleteMatchResultList);
        }
    }

    private Long getReportTypeId(MatchResult matchResult) {
        if (matchResult.isSuccess()) {
            return matchResult.getReportTypeId();
        }
        MatchException matchException = matchResult.getMatchException();
        MatchInfo matchInfo = matchException.getMatchInfo();
        if (Objects.isNull(matchInfo)) {
            return matchResult.getReportTypeId();
        }
        return matchInfo.getReportTypeId();
    }

    static class MatchErrorInfo {
        private final String uniqueKey;
        private final List<MatchResult> waitDeleteMatchResultList;
        private boolean hasSuccess;

        public MatchErrorInfo(String uniqueKey) {
            this.uniqueKey = uniqueKey;
            this.waitDeleteMatchResultList = new ArrayList<MatchResult>(16);
        }

        public void addMatchResult(MatchResult matchResult) {
            this.waitDeleteMatchResultList.add(matchResult);
        }

        public void markHasSuccess() {
            this.hasSuccess = true;
        }

        public List<MatchResult> getWaitDeleteMatchResultList() {
            return this.waitDeleteMatchResultList;
        }

        public boolean isHasSuccess() {
            return this.hasSuccess;
        }

        public String getUniqueKey() {
            return this.uniqueKey;
        }
    }
}

