/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.match.IControlMatchService;
import kd.tmc.fpm.business.mvc.service.match.impl.AbstractDecorationControlMatchService;
import kd.tmc.fpm.business.utils.CommonUtils;
import org.apache.commons.collections.CollectionUtils;

public class DataNotFoundFilterControlMatchService
extends AbstractDecorationControlMatchService {
    private static Log logger = LogFactory.getLog(DataNotFoundFilterControlMatchService.class);

    public DataNotFoundFilterControlMatchService(IControlMatchService controlMatchService, ControlContext controlContext) {
        super(controlMatchService, controlContext);
    }

    @Override
    protected void doProcessMatchResults(List<MatchResult> matchResultList) {
        logger.info("\u5339\u914d\u7ed3\u679c\u5927\u5c0f\uff1a{}\uff0c\u90e8\u5206\u5339\u914d\u7ed3\u679c\uff1a{}", (Object)matchResultList.size(), CommonUtils.getSubListForSize(matchResultList, 20));
        Map<Long, Map<String, List<MatchResult>>> systemMatchResultMap = matchResultList.stream().collect(Collectors.groupingBy(matchResult -> matchResult.getMatchRule().getSystemId(), Collectors.mapping(Function.identity(), Collectors.groupingBy(MatchResult::getUniqueKey))));
        for (Map.Entry<Long, Map<String, List<MatchResult>>> entry : systemMatchResultMap.entrySet()) {
            if (this.controlContext.getPlanExecuteOpType().isOccupy()) {
                Long systemId = entry.getKey();
                ControlTime controlTime = this.controlContext.getControlTime(systemId);
                if (Objects.isNull(controlTime)) continue;
                if (controlTime.isAllowSkip()) {
                    List failedList = entry.getValue().values().stream().flatMap(Collection::stream).filter(item -> !item.isSuccess()).filter(item -> item.getMatchException().getMatchErrorType().isMathNoData()).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(failedList)) {
                        matchResultList.removeAll(failedList);
                    }
                    entry.getValue().forEach((k, v) -> this.removeIfNeed(matchResultList, (List<MatchResult>)v));
                    continue;
                }
                List<Long> reportTypeIds = controlTime.getControledReportTypeIds();
                if (EmptyUtil.isNoEmpty(reportTypeIds)) continue;
            }
            entry.getValue().forEach((k, v) -> this.removeIfNeed(matchResultList, (List<MatchResult>)v));
        }
        logger.info("\u5904\u7406\u540e\u7684\u5339\u914d\u7ed3\u679c\u5927\u5c0f\uff1a{}\uff0c\u90e8\u5206\u5339\u914d\u7ed3\u679c\uff1a{}", (Object)matchResultList.size(), CommonUtils.getSubListForSize(matchResultList, 20));
    }

    private void removeIfNeed(List<MatchResult> matchResultList, List<MatchResult> waitCheckList) {
        ArrayList<MatchResult> waitDeleteList = new ArrayList<MatchResult>(waitCheckList.size());
        boolean hasSuccess = false;
        for (MatchResult matchResult : waitCheckList) {
            if (matchResult.isSuccess()) {
                hasSuccess = true;
                continue;
            }
            MatchException matchException = matchResult.getMatchException();
            if (!matchException.getMatchErrorType().isMathNoData() && !this.controlContext.getPlanExecuteOpType().isOccupy()) continue;
            waitDeleteList.add(matchResult);
        }
        if (hasSuccess) {
            matchResultList.removeAll(waitDeleteList);
        }
    }
}

