/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.match.GroupReportData;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.mvc.service.match.impl.AbstractControlMatchService;

public class DefaultControlMatchService
extends AbstractControlMatchService {
    @Override
    protected List<MatchResult> doMatch(List<MatchInfo> matchInfoList, List<GroupReportData> groupReportDataList) {
        List<MatchResult> matchResultList = super.doMatch(matchInfoList, groupReportDataList);
        Map matchInfoMap = matchInfoList.stream().collect(Collectors.toMap(MatchInfo::getUniqueId, Function.identity(), (a, b) -> a));
        HashMap<Long, PeriodMember> periodMemberMap = new HashMap<Long, PeriodMember>(groupReportDataList.size());
        for (MatchResult matchResult : matchResultList) {
            if (!matchResult.isSuccess() || EmptyUtil.isNoEmpty((Long)matchResult.getReportTypeId())) continue;
            PeriodMember periodMember = (PeriodMember)periodMemberMap.get(matchResult.getReportPeriod());
            if (Objects.nonNull(periodMember)) {
                matchResult.setReportTypeId(periodMember.getPeriodTypeId());
                continue;
            }
            MatchInfo matchInfo = (MatchInfo)matchInfoMap.get(matchResult.getUniqueKey());
            FundPlanSystem fundPlanSystem = matchInfo.getFundPlanSystem();
            Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
            periodMember = (PeriodMember)periodDim.getAllDimMemberList().stream().filter(p -> Objects.equals(p.getId(), matchResult.getReportPeriod())).findFirst().get();
            matchResult.setReportTypeId(periodMember.getPeriodTypeId());
            periodMemberMap.put(periodMember.getId(), periodMember);
        }
        return matchResultList;
    }
}

