/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.match.query.IReportDataQueryStrategy;
import kd.tmc.fpm.business.mvc.service.match.strategy.IMatchMemberStrategy;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public abstract class AbstractReportDataQueryStrategy
implements IReportDataQueryStrategy {
    private AbstractReportDataQueryStrategy abstractReportDataQueryStrategy;
    protected IReportDataQueryService reportDataQueryService;
    private List<IMatchMemberStrategy> matchMemberStrategyList;
    private IReportDataQueryStrategy.ISearchHook searchHook;

    public AbstractReportDataQueryStrategy() {
        this(null);
    }

    public AbstractReportDataQueryStrategy(AbstractReportDataQueryStrategy abstractReportDataQueryStrategy) {
        this.abstractReportDataQueryStrategy = abstractReportDataQueryStrategy;
        this.matchMemberStrategyList = new ArrayList<IMatchMemberStrategy>(8);
        this.reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
    }

    public AbstractReportDataQueryStrategy addMatchMemberStrategy(IMatchMemberStrategy matchMemberStrategy) {
        if (!this.matchMemberStrategyList.contains(matchMemberStrategy)) {
            this.matchMemberStrategyList.add(matchMemberStrategy);
        }
        return this;
    }

    public AbstractReportDataQueryStrategy setSearchHook(IReportDataQueryStrategy.ISearchHook searchHook) {
        this.searchHook = searchHook;
        return this;
    }

    @Override
    public List<ReportData> getMaybeMatchReportData(List<MatchInfo> matchInfoList) {
        if (Objects.nonNull(this.abstractReportDataQueryStrategy)) {
            return this.abstractReportDataQueryStrategy.getMaybeMatchReportData(matchInfoList);
        }
        if (EmptyUtil.isEmpty(matchInfoList)) {
            return Collections.emptyList();
        }
        if (EmptyUtil.isEmpty(this.matchMemberStrategyList)) {
            return Collections.emptyList();
        }
        return this.doGetMaybeMatchReportData(matchInfoList);
    }

    protected List<ReportData> doGetMaybeMatchReportData(List<MatchInfo> matchInfoList) {
        DimValueListInfo dimValueListInfo = new DimValueListInfo();
        for (MatchInfo matchInfo : matchInfoList) {
            this.matchMemberStrategyList.forEach(iMatchMemberStrategy -> iMatchMemberStrategy.process(matchInfo, dimValueListInfo));
        }
        List<ReportData> reportDataList = this.reportDataQueryService.queryReportDataForAllSystem(t -> {
            t.setDimIdList(dimValueListInfo.getDimensionList());
            t.setDimValList(dimValueListInfo.getDimValueList());
            t.setNeedDimIfValueIsNotEmpty(true);
            t.setEffectFlag(true);
            if (Objects.nonNull(this.searchHook)) {
                this.searchHook.beforeSearch((ReportDataQueryObject)t);
            }
        });
        return reportDataList;
    }
}

