/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.validate.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ValidateResult;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.match.validate.IMatchValidator;
import kd.tmc.fpm.business.mvc.service.match.validate.impl.MatchResultDetailControlValidator;
import kd.tmc.fpm.business.mvc.service.match.validate.impl.MatchResultMatchRuleDimValidator;
import kd.tmc.fpm.business.utils.CommonUtils;

public class MatchValidatorDelegate {
    private static final Log logger = LogFactory.getLog(MatchValidatorDelegate.class);
    private FpmOperateResult<List<MatchResult>> matchResultListResult;
    private ControlContext controlContext;
    private List<MatchResult> matchResultList;
    private IMatchValidator matchValidator;
    private FpmOperateResult<ControlResult> controlResultFpmOperateResult;
    private List<ValidateResult> validateResultList;

    public MatchValidatorDelegate(ControlContext controlContext, FpmOperateResult<List<MatchResult>> matchResultListResult) {
        this(controlContext, matchResultListResult, new MatchResultDetailControlValidator(new MatchResultMatchRuleDimValidator(controlContext)));
    }

    public MatchValidatorDelegate(ControlContext controlContext, FpmOperateResult<List<MatchResult>> matchResultListResult, IMatchValidator matchValidator) {
        this.matchResultListResult = matchResultListResult;
        this.matchValidator = matchValidator;
        this.matchResultList = matchResultListResult.getData();
        this.controlContext = controlContext;
        this.controlResultFpmOperateResult = FpmOperateResult.success(new ControlResult());
        this.validateResultList = new ArrayList<ValidateResult>(Objects.isNull(this.matchResultList) ? 1 : this.matchResultList.size());
    }

    public void validate() {
        if (EmptyUtil.isEmpty(this.matchResultListResult)) {
            this.controlResultFpmOperateResult.getData().setErrMsg("NO data matched");
            this.controlResultFpmOperateResult.setSuccess(false);
            return;
        }
        if (!this.matchResultListResult.isSuccess()) {
            String errMsg = this.matchResultListResult.getMessageList().stream().distinct().collect(Collectors.joining(";"));
            logger.error(String.format("\u6267\u884c\u51c6\u5907\u5931\u8d25\uff0c\u3010entityIds\uff1a%s\u3011|\u3010errMsg\uff1a%s\u3011", CommonUtils.getSubListForSize(this.controlContext.getControlExecuteParamList(), 3), errMsg));
            this.controlResultFpmOperateResult.setSuccess(false);
            this.controlResultFpmOperateResult.getData().setErrMsg(errMsg);
            return;
        }
        for (MatchResult matchResult : this.matchResultList) {
            ValidateResult validateResult = this.matchValidator.validate(matchResult);
            if (!matchResult.isSuccess() || validateResult.isSuccess()) continue;
            matchResult.setMatchException(validateResult.getMatchException());
            this.validateResultList.add(validateResult);
        }
    }

    public FpmOperateResult<ControlResult> getControlResult() {
        return this.controlResultFpmOperateResult;
    }

    public List<ValidateResult> getValidateResultList() {
        return this.validateResultList;
    }
}

