/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.params;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillDimensionMatchInfo {
    private Object billId;
    private TreeSet<MatchInfo> matchInfoTreeSet;
    private String sign;
    private boolean freeze;
    private Set<Long> skipDimIds;

    public BillDimensionMatchInfo(Object billId) {
        this.billId = billId;
        this.matchInfoTreeSet = new TreeSet((o1, o2) -> o1.getDimensionId().compareTo(((MatchInfo)o2).dimensionId));
        this.skipDimIds = new HashSet<Long>(4);
    }

    public boolean isFreeze() {
        return this.freeze;
    }

    public void freeze() {
        this.freeze = true;
    }

    public void unFreeze() {
        this.freeze = false;
        this.sign = "";
    }

    public String getSign() {
        this.freeze();
        if (EmptyUtil.isNoEmpty((String)this.sign)) {
            return this.sign;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.billId).append("#");
        for (MatchInfo matchInfo : this.matchInfoTreeSet) {
            Long dimensionId = matchInfo.getDimensionId();
            if (this.skipDimIds.contains(dimensionId)) continue;
            sb.append(dimensionId).append(matchInfo.getMatchValue());
        }
        this.sign = sb.toString();
        return this.sign;
    }

    public void addSkipDimId(Long dimId) {
        this.skipDimIds.add(dimId);
        this.unFreeze();
    }

    public void addMatchInfo(Long dimensionId, String billProp, Object matchValue) {
        if (this.freeze) {
            throw new KDBizException("BillDimensionMatchInfo is freeze");
        }
        if (EmptyUtil.isEmpty((Object)matchValue)) {
            return;
        }
        this.matchInfoTreeSet.add(new MatchInfo(dimensionId, billProp, matchValue));
    }

    static class MatchInfo {
        private Long dimensionId;
        private String billProp;
        private Object matchValue;

        public MatchInfo(Long dimensionId, String billProp, Object matchValue) {
            this.dimensionId = dimensionId;
            this.billProp = billProp;
            this.matchValue = matchValue;
        }

        public Long getDimensionId() {
            return this.dimensionId;
        }

        public void setDimensionId(Long dimensionId) {
            this.dimensionId = dimensionId;
        }

        public String getBillProp() {
            return this.billProp;
        }

        public void setBillProp(String billProp) {
            this.billProp = billProp;
        }

        public Object getMatchValue() {
            return this.matchValue;
        }

        public void setMatchValue(Object matchValue) {
            this.matchValue = matchValue;
        }
    }
}

