/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.params;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.service.params.BillDimensionMatchInfo;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;
import org.apache.commons.collections4.MapUtils;

public class ControlExecuteParam
implements Serializable,
Cloneable {
    private static Log logger = LogFactory.getLog(ControlExecuteParam.class);
    private BillBizInfo billBizInfo;
    private BillMatchRule matchRule;
    private Long systemId;
    private String bizOpName;
    private Long reportOrgId;
    private BigDecimal actAmount;
    private PlanExecuteOpType opType;
    private Boolean deleteStatus;
    private String uniqueId;
    private Map<TemplateDim, Object> detailMatchInfo = new HashMap<TemplateDim, Object>(16);
    private List<ReportData> matchedReportDataList;
    private List<ReportData> matchedSameReportDataList;
    private List<Long> detailMatchedDimIdS = new ArrayList<Long>(8);
    private List<Long> floatMatchedDimIdS = new ArrayList<Long>(8);
    private ReportData reportData;
    private Long reportTypeId;
    private boolean accurateMatch;
    private BigDecimal rate;
    private Date rateDate;
    private PlanExecuteRecord originalPlanExecuteRecord;
    private List<PlanExecuteRecord> relatePlanExecuteRecordList;
    private List<ReportData> relateReportDataList;
    private boolean exchanged;
    private String mergeKey;
    private BillDimensionMatchInfo billDimensionMatchInfo;
    private BigDecimal concurrentWriteAmt = BigDecimal.ZERO;
    private Long subjectId;
    private List<ReportData> optionalMaybeNeedReportDataList = new ArrayList<ReportData>(32);
    private BitMap<Long, Long> detailDimBitMap;
    private DimensionInfoBean dimensionInfoBean;
    private String failedCause;
    private Long bizCurrencyId;

    public BillBizInfo getBillBizInfo() {
        return this.billBizInfo;
    }

    public void setBillBizInfo(BillBizInfo billBizInfo) {
        this.billBizInfo = billBizInfo;
    }

    public BillMatchRule getMatchRule() {
        return this.matchRule;
    }

    public void setMatchRule(BillMatchRule matchRule) {
        this.matchRule = matchRule;
    }

    public BigDecimal getActAmount() {
        return CommonUtils.getValueIfNull(this.actAmount);
    }

    public void setActAmount(BigDecimal actAmount) {
        this.actAmount = actAmount;
    }

    public void setActAmountAndClearExchange(BigDecimal actAmount) {
        this.actAmount = actAmount;
        this.exchanged = false;
    }

    public void setActAmount(BigDecimal actAmount, boolean exchanged) {
        this.actAmount = actAmount;
        if (exchanged) {
            this.markExchanged();
        }
    }

    public Long getReportOrgId() {
        return this.reportOrgId;
    }

    public void setReportOrgId(Long reportOrgId) {
        this.reportOrgId = reportOrgId;
    }

    public String getBizOpName() {
        return this.bizOpName;
    }

    public void setBizOpName(String bizOpName) {
        this.bizOpName = bizOpName;
    }

    public PlanExecuteOpType getOpType() {
        return this.opType;
    }

    public void setOpType(PlanExecuteOpType opType) {
        this.opType = opType;
    }

    public Boolean getDeleteStatus() {
        return this.deleteStatus;
    }

    public void setDeleteStatus(Boolean deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Long getBizCurrencyId() {
        return this.bizCurrencyId;
    }

    public void setBizCurrencyId(Long bizCurrencyId) {
        this.bizCurrencyId = bizCurrencyId;
    }

    public ControlExecuteParam clone() {
        try {
            ControlExecuteParam record = (ControlExecuteParam)super.clone();
            return record;
        }
        catch (CloneNotSupportedException e) {
            logger.error((Throwable)e);
            return new ControlExecuteParam();
        }
    }

    public Map<TemplateDim, Object> getDetailMatchInfo() {
        if (MapUtils.isEmpty(this.detailMatchInfo)) {
            HashSet<Long> detailMatchedDimIdS = new HashSet<Long>(this.getDetailMatchedDimIdS());
            detailMatchedDimIdS.addAll(this.getFloatMatchedDimIdS());
            if (EmptyUtil.isEmpty(detailMatchedDimIdS)) {
                return this.detailMatchInfo;
            }
            List<TemplateDim> dimList = this.reportData.getDimList();
            List<Object> dataDimValList = this.reportData.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                Long dimensionId = templateDim.getDimensionId();
                if (!detailMatchedDimIdS.contains(dimensionId)) continue;
                this.detailMatchInfo.put(templateDim, dataDimValList.get(i));
            }
        }
        return this.detailMatchInfo;
    }

    public void setDetailMatchInfo(Map<TemplateDim, Object> detailMatchInfo) {
        if (MapUtils.isEmpty(detailMatchInfo)) {
            return;
        }
        this.detailMatchInfo = detailMatchInfo;
    }

    public List<ReportData> getMatchedReportDataList() {
        if (Objects.isNull(this.matchedReportDataList)) {
            this.matchedReportDataList = new ArrayList<ReportData>(2);
        }
        return this.matchedReportDataList;
    }

    public void setMatchedReportDataList(List<ReportData> matchedReportDataList) {
        this.matchedReportDataList = CommonUtils.getDistinctList(matchedReportDataList, ReportData::getId);
    }

    public List<Long> getDetailMatchedDimIdS() {
        if (EmptyUtil.isEmpty(this.detailMatchedDimIdS) && Objects.nonNull(this.detailDimBitMap) && !this.detailDimBitMap.isEmpty()) {
            this.detailMatchedDimIdS = new ArrayList<Long>(this.detailDimBitMap.getKeys(this.reportData.getId()));
        }
        return this.detailMatchedDimIdS;
    }

    public void setDetailMatchedDimIdS(List<Long> detailMatchedDimIdS) {
        if (EmptyUtil.isEmpty(detailMatchedDimIdS)) {
            return;
        }
        this.detailMatchedDimIdS = detailMatchedDimIdS;
    }

    public List<Long> getFloatMatchedDimIdS() {
        if (EmptyUtil.isEmpty(this.floatMatchedDimIdS) && Objects.nonNull(this.dimensionInfoBean)) {
            List dimensionIdList = this.dimensionInfoBean.getDimensionIdList();
            this.floatMatchedDimIdS = dimensionIdList.size() > 4 ? dimensionIdList.subList(4, dimensionIdList.size()) : this.floatMatchedDimIdS;
        }
        return this.floatMatchedDimIdS;
    }

    public void setFloatMatchedDimIdS(List<Long> floatMatchedDimIdS) {
        if (EmptyUtil.isEmpty(floatMatchedDimIdS)) {
            return;
        }
        this.floatMatchedDimIdS = floatMatchedDimIdS;
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public void setReportData(ReportData reportData) {
        this.reportData = reportData;
    }

    public boolean isAccurateMatch() {
        return this.accurateMatch;
    }

    public void setAccurateMatch(boolean accurateMatch) {
        this.accurateMatch = accurateMatch;
    }

    public BigDecimal getRate() {
        return Objects.isNull(this.rate) ? BigDecimal.ONE : this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Date getRateDate() {
        return this.rateDate;
    }

    public void setRateDate(Date rateDate) {
        this.rateDate = rateDate;
    }

    public Long getReportTypeId() {
        return this.reportTypeId;
    }

    public void setReportTypeId(Long reportTypeId) {
        this.reportTypeId = reportTypeId;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public PlanExecuteRecord getOriginalPlanExecuteRecord() {
        return this.originalPlanExecuteRecord;
    }

    public void setOriginalPlanExecuteRecord(PlanExecuteRecord originalPlanExecuteRecord) {
        this.originalPlanExecuteRecord = originalPlanExecuteRecord;
    }

    public List<PlanExecuteRecord> getRelatePlanExecuteRecordList() {
        if (Objects.isNull(this.relatePlanExecuteRecordList)) {
            return Collections.emptyList();
        }
        return this.relatePlanExecuteRecordList;
    }

    public void setRelatePlanExecuteRecordList(List<PlanExecuteRecord> relatePlanExecuteRecordList) {
        this.relatePlanExecuteRecordList = relatePlanExecuteRecordList;
    }

    public List<ReportData> getRelateReportDataList() {
        if (Objects.isNull(this.relateReportDataList)) {
            this.relateReportDataList = new ArrayList<ReportData>(128);
        }
        return this.relateReportDataList;
    }

    public void setRelateReportDataList(List<ReportData> relateReportDataList) {
        this.relateReportDataList = CommonUtils.getDistinctList(relateReportDataList, ReportData::getId);
    }

    public String getMergeKey() {
        return this.mergeKey;
    }

    public void setMergeKey(String mergeKey) {
        this.mergeKey = mergeKey;
    }

    public BillDimensionMatchInfo getBillDimensionMatchInfo() {
        return this.billDimensionMatchInfo;
    }

    public void setBillDimensionMatchInfo(BillDimensionMatchInfo billDimensionMatchInfo) {
        this.billDimensionMatchInfo = billDimensionMatchInfo;
    }

    public BigDecimal getConcurrentWriteAmt() {
        return this.concurrentWriteAmt;
    }

    public void setConcurrentWriteAmt(BigDecimal concurrentWriteAmt) {
        this.concurrentWriteAmt = concurrentWriteAmt;
    }

    public void addConcurrentWriteAmt(BigDecimal concurrentWriteAmt) {
        this.concurrentWriteAmt = this.concurrentWriteAmt.add(CommonUtils.getValueIfNull(concurrentWriteAmt));
    }

    public void markExchanged() {
        this.exchanged = true;
    }

    public Long getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public List<ReportData> getOptionalMaybeNeedReportDataList() {
        return this.optionalMaybeNeedReportDataList;
    }

    public BitMap<Long, Long> getDetailDimBitMap() {
        return this.detailDimBitMap;
    }

    public void setDetailDimBitMap(BitMap<Long, Long> detailDimBitMap) {
        this.detailDimBitMap = detailDimBitMap;
    }

    public DimensionInfoBean getDimensionInfoBean() {
        return this.dimensionInfoBean;
    }

    public void setDimensionInfoBean(DimensionInfoBean dimensionInfoBean) {
        this.dimensionInfoBean = dimensionInfoBean;
    }

    public boolean matchedDetail() {
        return Objects.nonNull(this.detailDimBitMap) && !this.detailDimBitMap.isEmpty();
    }

    public void setOptionalMaybeNeedReportDataList(List<ReportData> optionalMaybeNeedReportDataList) {
        if (EmptyUtil.isEmpty(optionalMaybeNeedReportDataList)) {
            return;
        }
        this.optionalMaybeNeedReportDataList = optionalMaybeNeedReportDataList;
    }

    public List<ReportData> getMatchedSameReportDataList() {
        if (Objects.isNull(this.matchedSameReportDataList)) {
            this.matchedSameReportDataList = new ArrayList<ReportData>(64);
        }
        return this.matchedSameReportDataList;
    }

    public String getFailedCause() {
        return this.failedCause;
    }

    public void setFailedCause(String failedCause) {
        this.failedCause = failedCause;
    }

    public boolean isFailed() {
        return EmptyUtil.isNoEmpty((String)this.failedCause);
    }

    public void setMatchedSameReportDataList(List<ReportData> matchedSameReportDataList) {
        this.matchedSameReportDataList = matchedSameReportDataList;
    }

    public List<ReportData> getDetailReportDataList() {
        BitMap<Long, Long> detailDimBitMap = this.getDetailDimBitMap();
        if (Objects.isNull(detailDimBitMap) || detailDimBitMap.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> detailReportDataIds = detailDimBitMap.values();
        List<ReportData> detailReportDataList = this.getMatchedSameReportDataList().stream().filter(rd -> detailReportDataIds.contains(rd.getId())).collect(Collectors.toList());
        detailReportDataList.addAll(this.getMatchedReportDataList().stream().filter(rd -> detailReportDataIds.contains(rd.getId())).collect(Collectors.toList()));
        detailReportDataList = CommonUtils.getDistinctList(detailReportDataList, ReportData::getId);
        return detailReportDataList;
    }

    public List<ReportData> getAllDetailReportDataList() {
        if (EmptyUtil.isEmpty(this.matchedSameReportDataList)) {
            return Collections.emptyList();
        }
        List<ReportData> reportDataArrayList = new ArrayList<ReportData>(this.matchedSameReportDataList);
        reportDataArrayList.addAll(this.matchedReportDataList);
        reportDataArrayList = reportDataArrayList.stream().filter(rd -> !rd.isMainTable()).collect(Collectors.toList());
        reportDataArrayList = CommonUtils.getDistinctList(reportDataArrayList, ReportData::getId);
        BitMap<Long, Long> detailDimBitMap = this.getDetailDimBitMap();
        if (Objects.isNull(detailDimBitMap) || detailDimBitMap.isEmpty()) {
            return reportDataArrayList;
        }
        Set<Long> detailReportDataIds = detailDimBitMap.values();
        return reportDataArrayList.stream().filter(rd -> detailReportDataIds.contains(rd.getId())).collect(Collectors.toList());
    }

    public void reBuildDetailDimensionInfo() {
        this.detailMatchedDimIdS.clear();
        this.detailMatchInfo.clear();
        this.getDetailMatchInfo();
    }

    public String toString() {
        return "ControlExecuteParam{billBizInfo=" + this.billBizInfo + ", matchRule=" + this.matchRule + ", bizOpName='" + this.bizOpName + '\'' + ", reportOrgId=" + this.reportOrgId + ", actAmount=" + this.actAmount + ", mergeKey=" + this.mergeKey + '}';
    }

    public ControlExecuteParam copy() {
        ControlExecuteParam controlExecuteParam = this.clone();
        controlExecuteParam.detailMatchInfo = new HashMap<TemplateDim, Object>(16);
        controlExecuteParam.matchedReportDataList = new ArrayList<ReportData>(16);
        controlExecuteParam.detailMatchedDimIdS = new ArrayList<Long>(16);
        controlExecuteParam.floatMatchedDimIdS = new ArrayList<Long>(16);
        controlExecuteParam.reportData = null;
        controlExecuteParam.accurateMatch = false;
        controlExecuteParam.setRate(BigDecimal.ZERO);
        controlExecuteParam.setRateDate(null);
        controlExecuteParam.setMergeKey(this.mergeKey);
        controlExecuteParam.setSubjectId(this.subjectId);
        controlExecuteParam.optionalMaybeNeedReportDataList = new ArrayList<ReportData>(8);
        controlExecuteParam.setDimensionInfoBean(null);
        controlExecuteParam.detailDimBitMap = null;
        controlExecuteParam.failedCause = null;
        return controlExecuteParam;
    }

    public BigDecimal getReportActAmount() {
        BigDecimal realAmount = this.getActAmount();
        if (Objects.isNull(this.rate)) {
            return realAmount;
        }
        if (Objects.isNull(this.reportData)) {
            return realAmount.multiply(this.rate);
        }
        AmountUnit amountUnit = this.reportData.getAmountUnit();
        realAmount = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (BigDecimal)this.getActAmount());
        return realAmount.multiply(this.rate);
    }

    public BigDecimal getExecuteActAmount() {
        BigDecimal actAmount = this.getActAmount();
        if (this.exchanged) {
            return actAmount;
        }
        if (Objects.isNull(this.rate)) {
            return actAmount;
        }
        return actAmount.multiply(this.rate);
    }
}

