/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.creator;

import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.helper.ReportPeriodHelper;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ReportCreator {
    private final FundPlanSystem fundPlanSystem;
    private final List<PeriodMember> periodMemberList;
    private final ReportPeriodType reportPeriodType;
    private final Map<Long, Integer> periodMemberIndexMap;
    private final Dimension periodDim;
    private final LinkedList<Long> idList;

    public ReportCreator(FundPlanSystem fundPlanSystem, Long reportTypeId) {
        this.fundPlanSystem = fundPlanSystem;
        Optional<ReportPeriodType> first = fundPlanSystem.getReportTypeList().stream().filter(rt -> Objects.equals(reportTypeId, rt.getReportPeriodId())).findFirst();
        if (!first.isPresent()) {
            throw new KDBizException("reportTypeId:" + reportTypeId + " is not exists");
        }
        this.idList = new LinkedList();
        this.reportPeriodType = first.get();
        this.periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        this.periodMemberList = this.periodDim.getAllDimMemberList().stream().map(PeriodMember.class::cast).filter(periodMember -> Objects.equals(reportTypeId, periodMember.getPeriodTypeId())).filter(DimMember::isEnable).filter(this::isPeriodType).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        this.periodMemberIndexMap = new HashMap<Long, Integer>(this.periodMemberList.size());
        for (int i = 0; i < this.periodMemberList.size(); ++i) {
            this.periodMemberIndexMap.put(this.periodMemberList.get(i).getId(), i);
        }
    }

    private boolean isPeriodType(PeriodMember periodMember) {
        boolean isMonthWeek;
        PeriodType periodMemberPeriodType;
        PeriodType periodType = this.reportPeriodType.getPeriodType();
        if (Objects.equals((Object)periodType, (Object)(periodMemberPeriodType = periodMember.getPeriodType()))) {
            return true;
        }
        boolean bl = isMonthWeek = PeriodType.MONTH_WEEK == this.reportPeriodType.getPeriodType();
        if (isMonthWeek) {
            return Objects.equals((Object)PeriodType.MONTH_WEEK, (Object)periodMemberPeriodType) || Objects.equals((Object)PeriodType.YEAR_WEEK, (Object)periodMemberPeriodType);
        }
        return false;
    }

    public Report createReport(ReportGenerateInfo reportGenerateInfo, ReportTemplate backUpTemplate) {
        List<TemplateReportType> reportTypeList;
        Optional<TemplateReportType> first;
        ReportGeneratePeriod reportGeneratePeriod = reportGenerateInfo.getReportGeneratePeriod();
        Long periodMemberId = reportGeneratePeriod.getPeriodMember().getId();
        Integer index = this.periodMemberIndexMap.get(periodMemberId);
        if (index == null) {
            throw new KDBizException("periodMemberId:" + periodMemberId + "is not enabled or not exists");
        }
        Integer rollNum = this.reportPeriodType.isRoll() ? this.reportPeriodType.getRollNum() : 1;
        List<PeriodMember> reportPeriodMemList = this.periodMemberList.subList(index, index + rollNum);
        ReportTemplate reportTemplate = reportGenerateInfo.getReportOrgTemplateInfo().getReportTemplate();
        OrgMember orgMember = reportGenerateInfo.getReportOrgTemplateInfo().getOrgMember();
        Report report = reportTemplate.getTemplateUse().isPlan() ? new Report() : new SumPlanReport();
        this.setId(report);
        report.setSystemId(backUpTemplate.getSystemId());
        report.setTemplate(backUpTemplate);
        report.setReportPeriodType(this.reportPeriodType);
        report.setPeriodMemberList(reportPeriodMemList);
        report.setCompanyMemberList(Collections.singletonList(orgMember));
        report.setCloseDate(reportGeneratePeriod.getEndDate());
        report.setExchangeRateDate(reportGeneratePeriod.getRateDate());
        report.setExchangeRateTableId(reportGeneratePeriod.getRateTableId());
        report.setName(backUpTemplate.getName());
        report.setStartDate(reportGeneratePeriod.getStartDate());
        TemplateUseType templateUse = backUpTemplate.getTemplateUse();
        if (templateUse == TemplateUseType.SUMMARY) {
            report.setReportPlanType(ReportPlanType.SUMPLAN);
        } else if (templateUse == TemplateUseType.PLANING) {
            report.setReportPlanType(ReportPlanType.REPORTPLAN);
        }
        if (!backUpTemplate.isMainTable()) {
            report.setParentTemplateId(reportTemplate.getId());
        }
        if ((first = (reportTypeList = reportTemplate.getReportTypeList()).stream().filter(item -> Objects.equals(item.getReportTypeId(), this.reportPeriodType.getReportPeriodId())).findFirst()).isPresent()) {
            TemplateReportType templateReportType = first.get();
            Long referenceReportTypeId = templateReportType.getReferenceReportTypeId();
            if (EmptyUtil.isEmpty((Long)referenceReportTypeId)) {
                return report;
            }
            ReportPeriodType referencePeriodType = this.fundPlanSystem.getPeriodTypeByPeriodTypeId(referenceReportTypeId);
            report.setReferencePeriodType(referencePeriodType);
            PeriodMember periodMember = this.buildReferencePeriodMemberInfo(referencePeriodType, reportPeriodMemList.get(0));
            report.setReferencePeriodMember(periodMember);
        }
        return report;
    }

    private void setId(Report report) {
        if (this.idList.isEmpty()) {
            Deque<Long> deque = CommonUtils.batchGenerateIds(10);
            while (!deque.isEmpty()) {
                this.idList.add(deque.poll());
            }
        }
        report.setId(this.idList.removeFirst());
    }

    private PeriodMember buildReferencePeriodMemberInfo(ReportPeriodType referencePeriodType, PeriodMember periodMember) {
        if (referencePeriodType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u672a\u67e5\u8be2\u5230\u7f16\u62a5\u7c7b\u578b", (String)"ReportService_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (Objects.equals(referencePeriodType.getReportPeriodId(), this.reportPeriodType.getReportPeriodId())) {
            Integer index = this.periodMemberIndexMap.get(periodMember.getId());
            if (index > 0) {
                return this.periodMemberList.get(index - 1);
            }
            return null;
        }
        return this.periodDim.getAllDimMemberList().stream().map(PeriodMember.class::cast).filter(DimMember::isEnable).filter(p -> !ReportPeriodHelper.periodTypeEqual(this.reportPeriodType, p.getPeriodType())).filter(DimMember::isEnable).filter(o -> o.getStartDate().compareTo(periodMember.getStartDate()) < 0).sorted(Comparator.comparing(PeriodMember::getStartDate).reversed()).limit(1L).findFirst().orElse(null);
    }
}

