/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.domain;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;

public class ReportGenerateMessage {
    private final Map<Long, MessageItem> messageItemMap = new LinkedHashMap<Long, MessageItem>(16);

    public MessageItem getOrRegister(Long reportTemplateId) {
        return this.messageItemMap.computeIfAbsent(reportTemplateId, k -> new MessageItem());
    }

    public String getAllMessage(String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (MessageItem messageItem : this.messageItemMap.values()) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(String.join((CharSequence)delimiter, messageItem.messages));
        }
        return sb.toString();
    }

    public boolean hasFailed() {
        return MapUtils.isNotEmpty(this.messageItemMap);
    }

    public static class MessageItem {
        private final Set<String> messages = new LinkedHashSet<String>(16);

        public void addMessage(String message) {
            this.messages.add(message);
        }
    }
}

