/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.domain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;

public class ReportGenerateParam {
    private final ReportPrepare reportPrepare;
    private final FundPlanSystem fundPlanSystem;
    private final List<PeriodMember> periodMemberList;

    public ReportGenerateParam(ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem) {
        this.reportPrepare = reportPrepare;
        this.fundPlanSystem = fundPlanSystem;
        this.periodMemberList = new ArrayList<PeriodMember>(16);
    }

    public ReportPrepare getReportPrepare() {
        return this.reportPrepare;
    }

    public FundPlanSystem getFundPlanSystem() {
        return this.fundPlanSystem;
    }

    public List<PeriodMember> getPeriodMemberList() {
        return this.periodMemberList;
    }

    public void addPeriodMember(PeriodMember periodMember) {
        this.periodMemberList.add(periodMember);
    }

    public static ReportGenerateParam getInstance(Long reportPrepareId) {
        if (EmptyUtil.isEmpty((Long)reportPrepareId)) {
            throw new KDBizException("reportPrepareId is empty.");
        }
        ReportRepository reportRepo = new ReportRepository();
        ReportPrepare reportPrepare = reportRepo.loadReportPrepare(reportPrepareId);
        Long systemId = reportPrepare.getSystemId();
        DimensionRepository dimensionRepository = new DimensionRepository();
        FundPlanSystem fundPlanSystem = dimensionRepository.loadSystem(systemId);
        return new ReportGenerateParam(reportPrepare, fundPlanSystem);
    }

    public static ReportGenerateParam getInstance(Long reportPrepareId, List<Long> reportPeriodMemberIdList) {
        ReportGenerateParam reportGenerateParam = ReportGenerateParam.getInstance(reportPrepareId);
        if (EmptyUtil.isEmpty(reportPeriodMemberIdList)) {
            return reportGenerateParam;
        }
        FundPlanSystem fundPlanSystem = reportGenerateParam.getFundPlanSystem();
        Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        HashSet<Long> ids = new HashSet<Long>(reportPeriodMemberIdList);
        periodDim.getAllDimMemberList().stream().filter(dimMember -> ids.contains(dimMember.getId())).map(PeriodMember.class::cast).forEach(reportGenerateParam::addPeriodMember);
        return reportGenerateParam;
    }
}

