/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.filter.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportOrgTemplateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.filter.IReportOrgTemplateInfoFilter;

public class ReportOrgEnableFilterImpl
implements IReportOrgTemplateInfoFilter {
    private static final Log logger = LogFactory.getLog(ReportOrgEnableFilterImpl.class);

    @Override
    public List<ReportOrgTemplateInfo> filter(List<ReportOrgTemplateInfo> reportOrgTemplateInfoList) {
        ArrayList<ReportOrgTemplateInfo> result = new ArrayList<ReportOrgTemplateInfo>(reportOrgTemplateInfoList.size());
        Date currentDate = DateUtils.getCurrentDate();
        for (ReportOrgTemplateInfo reportOrgTemplateInfo : reportOrgTemplateInfoList) {
            OrgMember orgMember = reportOrgTemplateInfo.getOrgMember();
            if (!orgMember.isEnable()) {
                logger.info("\u7f16\u62a5\u4e3b\u4f53:{}\u5df2\u7981\u7528", (Object)orgMember.getName());
                continue;
            }
            Date enableDate = orgMember.getEnableDate();
            if (enableDate.after(currentDate)) {
                logger.info("\u7f16\u62a5\u4e3b\u4f53:{}\u5c1a\u672a\u5230\u8fbe\u7684\u751f\u6548\u65f6\u95f4", (Object)orgMember.getName());
                continue;
            }
            Date disableDate = orgMember.getDisableDate();
            if (disableDate.before(currentDate)) {
                logger.info("\u7f16\u62a5\u4e3b\u4f53:{}\u5df2\u8d85\u8fc7\u5931\u6548\u65f6\u95f4", (Object)orgMember.getName());
                continue;
            }
            result.add(reportOrgTemplateInfo);
        }
        return result;
    }
}

