/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.filter.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportOrgTemplateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.filter.IReportOrgTemplateInfoFilter;
import kd.tmc.fpm.business.utils.LogHelper;

public class SumPlanConfigFilterImpl
implements IReportOrgTemplateInfoFilter {
    private static final Log logger = LogFactory.getLog(SumPlanConfigFilterImpl.class);
    private final ISumPlanRepository sumPlanRepository;
    private final Long reportTypeId;

    public SumPlanConfigFilterImpl(Long reportTypeId) {
        this.reportTypeId = reportTypeId;
        this.sumPlanRepository = new SumPlanRepository();
    }

    @Override
    public List<ReportOrgTemplateInfo> filter(List<ReportOrgTemplateInfo> reportOrgTemplateInfoList) {
        List sumPlanTemplateInfoList = reportOrgTemplateInfoList.stream().filter((? super T reportOrgTemplateInfo) -> reportOrgTemplateInfo.getReportTemplate().getTemplateUse().isSummary()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(sumPlanTemplateInfoList)) {
            return reportOrgTemplateInfoList;
        }
        Long systemId = reportOrgTemplateInfoList.get(0).getReportTemplate().getSystemId();
        SumPlanParamConfig sumPlanParamConfig = this.sumPlanRepository.loadSumConfigBySystem(systemId, this.reportTypeId);
        if (sumPlanParamConfig == null) {
            logger.info("\u4f53\u7cfb\uff1a{},\u7f16\u62a5\u7c7b\u578b\uff1a{}\u4e0d\u80fd\u5b58\u5728\u53ef\u7528\u7684\u6c47\u603b\u53c2\u6570\uff0c\u5c06\u79fb\u9664\u6240\u6709\u6c47\u603b\u751f\u6210\u53c2\u6570", (Object)systemId, (Object)this.reportTypeId);
            reportOrgTemplateInfoList.removeAll(sumPlanTemplateInfoList);
            return reportOrgTemplateInfoList;
        }
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        Map sumPlanParamConfigInfoMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
        LogHelper logHelper = LogHelper.get(logger);
        for (ReportOrgTemplateInfo reportOrgTemplateInfo2 : sumPlanTemplateInfoList) {
            OrgMember orgMember = reportOrgTemplateInfo2.getOrgMember();
            SumPlanParamConfigInfo sumPlanParamConfigInfo = (SumPlanParamConfigInfo)sumPlanParamConfigInfoMap.get(orgMember.getId());
            if (sumPlanParamConfigInfo.isSumAuditNode()) continue;
            logHelper.logger("sumPlanTemplate assigned reportOrg:{} is not a sumAuditNode", orgMember.getName());
            reportOrgTemplateInfoList.remove(reportOrgTemplateInfo2);
        }
        logHelper.info();
        return reportOrgTemplateInfoList;
    }
}

