/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.report.generate.IReportGenerateInfoGenerate;
import kd.tmc.fpm.business.mvc.service.report.generate.IReportGenerateService;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateParam;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateResult;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportPrepareRecord;
import kd.tmc.fpm.business.mvc.service.report.generate.enums.ExecuteResult;
import kd.tmc.fpm.business.mvc.service.report.generate.factory.ReportGenerateInfoGenerateFactory;
import kd.tmc.fpm.business.mvc.service.report.generate.factory.ReportGeneratorFactory;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.IReportGenerator;
import kd.tmc.fpm.common.helper.StringHelper;

public class ReportGenerateServiceImpl
implements IReportGenerateService {
    private final IDataSaveService dataSaveService = new DataSaveServiceImpl();

    @Override
    public void generate(ReportGenerateParam reportGenerateParam) {
        IReportGenerateInfoGenerate reportGenerateInfoGenerate = ReportGenerateInfoGenerateFactory.getReportGenerateInfoGenerate(reportGenerateParam);
        FpmOperateResult<List<ReportGenerateInfo>> listFpmOperateResult = reportGenerateInfoGenerate.generateReportGenerateInfo();
        ReportPrepare reportPrepare = reportGenerateParam.getReportPrepare();
        if (!listFpmOperateResult.isSuccess()) {
            String errorMsg = this.addTipsMsgIfNeed(String.join((CharSequence)";", listFpmOperateResult.getMessageList()), listFpmOperateResult.getTipsInfoList());
            this.insertExecuteRecord(ReportPrepareRecord.error(errorMsg), reportPrepare);
            return;
        }
        IReportGenerator reportGenerator = ReportGeneratorFactory.getReportGenerator(reportGenerateParam.getFundPlanSystem());
        ReportGenerateResult reportGenerateResult = reportGenerator.generateReport(listFpmOperateResult.getData());
        if (reportGenerateResult.isFailed()) {
            String errorMsg = this.addTipsMsgIfNeed(reportGenerateResult.getErrorMsg(), listFpmOperateResult.getTipsInfoList());
            this.insertExecuteRecord(ReportPrepareRecord.error(errorMsg), reportPrepare);
            return;
        }
        this.insertExecuteRecord(this.generateExecuteRecord(reportGenerateResult, listFpmOperateResult.getTipsInfoList()), reportPrepare);
    }

    private String addTipsMsgIfNeed(String msg, List<String> tipsInfoList) {
        if (EmptyUtil.isEmpty(tipsInfoList)) {
            return msg;
        }
        String tipsMsg = String.join((CharSequence)",", tipsInfoList);
        return String.format("%s;%s", msg, tipsMsg);
    }

    private void insertExecuteRecord(ReportPrepareRecord reportPrepareRecord, ReportPrepare reportPrepare) {
        this.dataSaveService.updateBySqlInfo(() -> "update t_fpm_fpmbillgenrecord set fseq=fseq+1 where fid=?", Collections.singletonList(reportPrepare), (t, d) -> d.add(t.getId()));
        this.dataSaveService.saveEntryDataThrow(Collections.singletonList(reportPrepareRecord), reportPrepare.getId());
    }

    private ReportPrepareRecord generateExecuteRecord(ReportGenerateResult reportGenerateResult, List<String> tipsMsgList) {
        ReportPrepareRecord reportPrepareRecord = new ReportPrepareRecord();
        reportPrepareRecord.setId(DB.genGlobalLongId());
        reportPrepareRecord.setReportIds(reportGenerateResult.getSaveSuccessReportIds().stream().map(String::valueOf).collect(Collectors.joining(";")));
        reportPrepareRecord.setExecuteTime(new Date());
        if (reportGenerateResult.hasSucceed()) {
            String message = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u751f\u6210\u8d44\u91d1\u8ba1\u5212\u5355\u636e%1$s\u6761", (String)"ReportGenerateServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), reportGenerateResult.getCount());
            String resultMessage = StringHelper.getStringValue((Object)reportGenerateResult.getMessage());
            if (EmptyUtil.isNoEmpty((String)resultMessage)) {
                message = message + ", " + resultMessage;
            }
            reportPrepareRecord.setDetail(this.addTipsMsgIfNeed(message, tipsMsgList));
            reportPrepareRecord.setExecuteResult(EmptyUtil.isEmpty((String)resultMessage) ? ExecuteResult.SUCCESS : ExecuteResult.SOME_SUCCESS);
        } else {
            reportPrepareRecord.setExecuteResult(ExecuteResult.FAILURE);
            String message = StringHelper.getStringValue((Object)reportGenerateResult.getMessage());
            reportPrepareRecord.setDetail(this.addTipsMsgIfNeed(message, tipsMsgList));
        }
        reportPrepareRecord.setOperatorUser(RequestContext.get().getCurrUserId());
        reportPrepareRecord.setSeq(1);
        return reportPrepareRecord;
    }
}

