/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import kd.tmc.fpm.business.domain.enums.ReportPreSubLevel;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.report.generate.IReportGenerateInfoGenerate;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.mvc.service.report.generate.impl.AbstractReportGenerateInfoGenerate;

public class ReportOrgDefineEndTimeReportGenerateInfoGenerateImpl
extends AbstractReportGenerateInfoGenerate {
    private ReportPrepare reportPrepare;

    public ReportOrgDefineEndTimeReportGenerateInfoGenerateImpl(ReportPrepare reportPrepare, IReportGenerateInfoGenerate reportGenerateInfoGenerate) {
        super(reportGenerateInfoGenerate);
        this.reportPrepare = reportPrepare;
    }

    @Override
    public FpmOperateResult<List<ReportGenerateInfo>> generateReportGenerateInfo() {
        FpmOperateResult<List<ReportGenerateInfo>> listFpmOperateResult = super.generateReportGenerateInfo();
        if (!listFpmOperateResult.isSuccess()) {
            return listFpmOperateResult;
        }
        List<ReportGenerateInfo> reportGenerateInfoList = listFpmOperateResult.getData();
        if (this.reportPrepare == null) {
            return listFpmOperateResult;
        }
        if (!this.reportPrepare.isCtrOrgLevel()) {
            return listFpmOperateResult;
        }
        ReportPreSubLevel reportPreSubLevel = this.reportPrepare.getReportPreSubLevel();
        if (reportPreSubLevel == null) {
            return listFpmOperateResult;
        }
        int level = reportPreSubLevel.getLevel();
        LocalTime closeTime = this.reportPrepare.getSubCloseTime();
        for (ReportGenerateInfo reportGenerateInfo : reportGenerateInfoList) {
            OrgMember orgMember = reportGenerateInfo.getReportOrgTemplateInfo().getOrgMember();
            if (orgMember.getLevel() < level) continue;
            ReportGeneratePeriod reportGeneratePeriod = reportGenerateInfo.getReportGeneratePeriod();
            Date endDate = reportGeneratePeriod.getEndDate();
            Instant instant = endDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate localDate = instant.atZone(zoneId).toLocalDate();
            LocalDateTime localDateTime = LocalDateTime.of(localDate, closeTime);
            endDate = Date.from(localDateTime.atZone(zoneId).toInstant());
            reportGeneratePeriod.setEndDate(endDate);
        }
        return listFpmOperateResult;
    }
}

