/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.IReportGeneratePeriodStrategy;

public class HistoryReportGeneratePeriodStrategy
implements IReportGeneratePeriodStrategy {
    private List<PeriodMember> periodMemberList;

    public HistoryReportGeneratePeriodStrategy(List<PeriodMember> periodMemberList) {
        this.periodMemberList = periodMemberList;
    }

    @Override
    public List<ReportGeneratePeriod> getReportGeneratePeriodList() {
        if (EmptyUtil.isEmpty(this.periodMemberList)) {
            return Collections.emptyList();
        }
        Date currentDate = DateUtils.getCurrentDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.set(5, 1);
        Date startDate = calendar.getTime();
        Date startTime = DateUtils.getDataFormat((Date)startDate, (boolean)true);
        calendar.add(2, 1);
        calendar.add(5, -1);
        Date endDate = calendar.getTime();
        Date endTime = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        ArrayList<ReportGeneratePeriod> reportGeneratePeriodList = new ArrayList<ReportGeneratePeriod>(16);
        for (PeriodMember periodMember : this.periodMemberList) {
            ReportGeneratePeriod reportGeneratePeriod = new ReportGeneratePeriod(periodMember);
            reportGeneratePeriod.setStartDate(startTime);
            reportGeneratePeriod.setEndDate(endTime);
            reportGeneratePeriodList.add(reportGeneratePeriod);
        }
        return reportGeneratePeriodList;
    }
}

