/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl;

import java.util.Date;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.enums.ReportPreRateDateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.mvc.service.report.generate.exception.UnKnowRateDateTypeException;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.IReportGeneratePeriodStrategy;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl.AbstractReportGeneratePeriodStrategy;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl.FixedFrequencyDateReportGeneratePeriodStrategy;

public class RateDateReportGeneratePeriodStrategy
extends AbstractReportGeneratePeriodStrategy {
    public RateDateReportGeneratePeriodStrategy(ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem) {
        this(new FixedFrequencyDateReportGeneratePeriodStrategy(reportPrepare, fundPlanSystem));
    }

    public RateDateReportGeneratePeriodStrategy(AbstractReportGeneratePeriodStrategy abstractReportGeneratePeriodStrategy) {
        super(abstractReportGeneratePeriodStrategy);
    }

    public RateDateReportGeneratePeriodStrategy(IReportGeneratePeriodStrategy reportGeneratePeriodStrategy, ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem) {
        super(reportGeneratePeriodStrategy, reportPrepare, fundPlanSystem);
    }

    @Override
    public List<ReportGeneratePeriod> getReportGeneratePeriodList() {
        List<ReportGeneratePeriod> reportGeneratePeriodList = super.getReportGeneratePeriodList();
        ReportPreRateDateType rateDateType = this.reportPrepare.getRateDateType();
        if (rateDateType == null) {
            throw new KDBizException("rateDateType is null");
        }
        block6: for (ReportGeneratePeriod reportGeneratePeriod : reportGeneratePeriodList) {
            PeriodMember periodMember = reportGeneratePeriod.getPeriodMember();
            reportGeneratePeriod.setRateTableId(this.reportPrepare.getExchangeRateTableId());
            switch (rateDateType) {
                case REPORT_START_CUR: {
                    reportGeneratePeriod.setRateDate(reportGeneratePeriod.getStartDate());
                    continue block6;
                }
                case PERIOD_LASTMONTH_END: {
                    Date lastMonth = DateUtils.getLastMonth((Date)periodMember.getStartDate(), (int)1);
                    reportGeneratePeriod.setRateDate(DateUtils.getLastDayOfMonth((Date)lastMonth));
                    continue block6;
                }
                case PERIOD_STARTDAY_CUR: {
                    reportGeneratePeriod.setRateDate(periodMember.getStartDate());
                    continue block6;
                }
                case PERIOD_MONTHFIRST_FIRST: {
                    reportGeneratePeriod.setRateDate(DateUtils.getFirstDayOfMonth((Date)periodMember.getStartDate()));
                    continue block6;
                }
            }
            throw new UnKnowRateDateTypeException("unKnow rate date type:" + (Object)((Object)rateDateType));
        }
        return reportGeneratePeriodList;
    }
}

