/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask;

import java.util.HashMap;
import java.util.Map;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessService;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.ReportPlanAuditTaskProcessServiceImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.ReportPlanChangeSumTaskProcessServiceImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.ReportPlanUnAuditTaskProcessServiceImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskCleanTaskProcessServiceImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.UnCompleteApprovedRecordUpdateTaskProcessServiceImpl;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class TaskSequentFactory {
    private static Map<TaskType, TaskProcessService> processServiceMap = new HashMap<TaskType, TaskProcessService>(8);

    public static TaskProcessService getService(String taskType) {
        TaskType type = TaskType.getByName(taskType);
        return TaskSequentFactory.getService(type);
    }

    public static TaskProcessService getService(TaskType type) {
        FpmAssertUtil.isNotNull((Object)((Object)type), (String)"task type is null");
        TaskProcessService taskProcessService = processServiceMap.get((Object)type);
        FpmAssertUtil.isNotNull((Object)taskProcessService, (String)"task process service is null");
        return taskProcessService;
    }

    static {
        processServiceMap.put(TaskType.REPORT_PLAN_CHANGE_TASK, new ReportPlanChangeSumTaskProcessServiceImpl());
        processServiceMap.put(TaskType.UN_COMPLETE_APPROVED_RECORD_UPDATE_TASK, new UnCompleteApprovedRecordUpdateTaskProcessServiceImpl());
        processServiceMap.put(TaskType.REPORT_PLAN_AUDIT, new ReportPlanAuditTaskProcessServiceImpl());
        processServiceMap.put(TaskType.REPORT_PLAN_UN_AUDIT, new ReportPlanUnAuditTaskProcessServiceImpl());
        processServiceMap.put(TaskType.TASK_CLEAN, new TaskCleanTaskProcessServiceImpl());
    }
}

