/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessServiceLifeCycleListener;

public class ReportPlanIdempotenceAuditUnAuditListenerImpl
implements TaskProcessServiceLifeCycleListener {
    private static final Log logger = LogFactory.getLog(ReportPlanIdempotenceAuditUnAuditListenerImpl.class);

    @Override
    public void initialize(List<TaskRecord> taskRecordList) {
        if (EmptyUtil.isEmpty(taskRecordList)) {
            return;
        }
        Map<Long, List<TaskRecord>> map = taskRecordList.stream().collect(Collectors.groupingBy(TaskRecord::getObjectId));
        String selectFields = String.join((CharSequence)",", "id", "billstatus");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", map.keySet())});
        Map<Long, String> stringMap = dynamicObjectCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billstatus")));
        TaskRecord taskRecord = taskRecordList.get(0);
        String taskType = taskRecord.getTaskType();
        String exceptStatus = Objects.equals(taskType, TaskType.REPORT_PLAN_UN_AUDIT.name()) ? ReportProcessStatus.SAVE.getValue() : ReportProcessStatus.AUDIT.getValue();
        for (Map.Entry<Long, List<TaskRecord>> entry : map.entrySet()) {
            String billStatus = stringMap.get(entry.getKey());
            if (!Objects.equals(billStatus, exceptStatus)) continue;
            logger.info("\u4e1a\u52a1\u5bf9\u8c61\uff1a{}\u4e3a\u91cd\u590d\u6267\u884c\u7684\u4efb\u52a1\uff0c\u540c\u5bf9\u8c61\u540c\u7c7b\u578b\u7684\u4efb\u52a1\u5df2\u6709\u522b\u7684\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u3002", (Object)entry.getKey());
            List<TaskRecord> taskRecords = entry.getValue();
            taskRecords.forEach(tr -> tr.setIgnore(true));
        }
    }

    @Override
    public void done() {
    }
}

