/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessServiceLifeCycleListener;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.RepeatTaskIgnoreTaskProcessServiceLifeCycleListenerImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.ReportPlanIdempotenceAuditUnAuditListenerImpl;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class ReportPlanUnAuditTaskProcessServiceImpl
implements TaskProcessService {
    private final ReportBizService reportBizService = new ReportBizService();
    private final IDataSaveService dataSaveService = new DataSaveServiceImpl();
    private final ReportRepository repository = new ReportRepository();

    @Override
    public void doProcess(TaskRecord taskRecord) {
        String taskInfo = taskRecord.getTaskInfo();
        Map params = (Map)SerializationUtils.fromJsonString((String)taskInfo, HashMap.class);
        String reportIdStr = StringHelper.getStringValue(params.get("reportPlanId"));
        FpmAssertUtil.isNotBlank((String)reportIdStr, (String)"reportId is empty.");
        long reportId = Long.parseLong(reportIdStr);
        Report report = this.repository.loadReportWithAllDimension(reportId);
        FpmOperateResult operateResult = this.reportBizService.unAuditReport(report, ReportOpType.OP);
        if (!operateResult.isSuccess()) {
            throw new KDBizException(String.join((CharSequence)";", CommonUtils.getOrDefault(operateResult.getMessageList(), new ArrayList(1))));
        }
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fbillstatus=? where fid=?", Collections.singletonList(reportId), (t, d) -> {
            d.add(ReportProcessStatus.SAVE.getValue());
            d.add(t);
        });
    }

    @Override
    public TaskType getTaskType() {
        return null;
    }

    @Override
    public List<TaskProcessServiceLifeCycleListener> getTaskProcessServiceListeners() {
        return ListHelper.asList(new RepeatTaskIgnoreTaskProcessServiceLifeCycleListenerImpl(), new ReportPlanIdempotenceAuditUnAuditListenerImpl());
    }
}

