/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.IEvaluateAmtBizService;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.EvaluateAmtBizServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class UnCompleteApprovedRecordUpdateTaskProcessServiceImpl
implements TaskProcessService {
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private IEvaluateAmtBizService iEvaluateAmtBizService = new EvaluateAmtBizServiceImpl();
    private ISumPlanRepository iSumPlanRepository = FpmServiceFactory.getBizService(ISumPlanRepository.class);
    private IReportBizService iReportBizService = new ReportBizService();

    @Override
    public void doProcess(TaskRecord taskRecord) {
        String taskInfo = taskRecord.getTaskInfo();
        Map params = (Map)SerializationUtils.fromJsonString((String)taskInfo, HashMap.class);
        Object sumRecordId = params.get("sumPlanRecordId");
        Object systemId = params.get("systemId");
        FpmAssertUtil.isNotNull(sumRecordId, (String)"sumRecordId is null");
        FpmAssertUtil.isNotNull(systemId, (String)"systemId id is null");
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(Long.parseLong(systemId.toString()));
        SumPlanRecord sumPlanRecord = this.iSumPlanRepository.loadSumPlanRecord(Long.parseLong(sumRecordId.toString()));
        ApprovedAmountRecord approvedAmountRecord = this.iSumPlanRepository.loadApprovedAmtBySumId(Long.parseLong(sumRecordId.toString()));
        if (fundPlanSystem == null || sumPlanRecord == null || approvedAmountRecord == null) {
            this.updateTaskStatus(false, taskRecord);
            return;
        }
        List<Long> originalReportIdList = sumPlanRecord.getOriginalReportIdList();
        Long reportId = originalReportIdList.get(0);
        FpmOperateResult<Report> reportFpmOperateResult = this.iReportBizService.loadReport(reportId, fundPlanSystem, true);
        if (!reportFpmOperateResult.isSuccess()) {
            this.updateTaskStatus(false, taskRecord);
            return;
        }
        SumPlanReport report = (SumPlanReport)reportFpmOperateResult.getData();
        sumPlanRecord.setSumPlanReportList(Collections.singletonList(report));
        List<Long> approvedIds = this.loadApprovedSumRDIdStrList(approvedAmountRecord);
        if (EmptyUtil.isEmpty(approvedIds)) {
            this.updateTaskStatus(true, taskRecord);
        }
        FpmOperateResult<Void> updateResult = this.iEvaluateAmtBizService.updateUnCompleteApprovedRecord(approvedAmountRecord, sumPlanRecord, fundPlanSystem, approvedIds);
        this.updateTaskStatus(updateResult.isSuccess(), taskRecord);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.UN_COMPLETE_APPROVED_RECORD_UPDATE_TASK;
    }

    private void updateTaskStatus(boolean isSuccess, TaskRecord taskRecord) {
        if (isSuccess) {
            taskRecord.setStatus(TaskStatus.DONE.name());
        } else {
            taskRecord.setStatus(TaskStatus.FAILED.name());
        }
    }

    private List<Long> loadApprovedSumRDIdStrList(ApprovedAmountRecord approvedAmountRecord) {
        return approvedAmountRecord.getAmountAmtInfoList().stream().map(ApprovedAmountAmtInfo::getReportDataId).collect(Collectors.toList());
    }
}

