/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.smartcollect.impl;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fpm.business.domain.model.smartcollect.CollectLog;
import kd.tmc.fpm.business.mvc.service.smartcollect.CollectLogQueryService;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.property.GatherLoggerProp;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class CollectLogQueryServiceImpl
implements CollectLogQueryService {
    @Override
    public int countCollectLogsByEndTime(Date endTime) {
        FpmAssertUtil.isNotNull((Object)endTime, (String)"endTime is null");
        return FpmDataServiceHelper.count("fpm_collectlog", new QFilter[]{new QFilter("createtime", "<", (Object)endTime)});
    }

    @Override
    public List<CollectLog> queryCollectLogsByEndTime(Date endTime, Integer limit) {
        FpmAssertUtil.isNotNull((Object)endTime, (String)"endTime is null");
        FpmAssertUtil.isNotNull((Object)limit, (String)"limit is null");
        DynamicObject[] collectLogIds = BusinessDataServiceHelper.load((String)"fpm_collectlog", (String)GatherLoggerProp.HEAD_PROP, (QFilter[])new QFilter[]{new QFilter("createtime", "<", (Object)endTime)}, (String)"", (int)limit);
        if (collectLogIds == null || collectLogIds.length == 0) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return Arrays.stream(collectLogIds).map(this::convert).collect(Collectors.toList());
    }

    public CollectLog convert(DynamicObject dynamicObject) {
        CollectLog collectLog = new CollectLog();
        collectLog.setId((Long)dynamicObject.getPkValue());
        collectLog.setBillNo(dynamicObject.getString("billno"));
        collectLog.setCreateTime(dynamicObject.getDate("createtime"));
        return collectLog;
    }
}

