/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.system.impl;

import java.util.List;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.service.system.DimensionQueryService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.collections.CollectionUtils;

public class DimensionQueryServiceImpl
implements DimensionQueryService {
    private IDimensionRepository dimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);

    @Override
    public Dimension getOrgDimensionBySystemId(long systemId) {
        FpmAssertUtil.isTrue((systemId > 0L ? 1 : 0) != 0, (String)"systemId is null");
        List<Dimension> dimensions = this.dimensionRepository.loadMainDimensionBySystemId(systemId, DimensionType.ORG);
        if (CollectionUtils.isEmpty(dimensions)) {
            return null;
        }
        return dimensions.get(0);
    }

    @Override
    public List<Dimension> loadDimensions(long systemId) {
        FpmAssertUtil.isTrue((systemId > 0L ? 1 : 0) != 0, (String)"systemId is null");
        return this.dimensionRepository.loadDimensions(systemId);
    }

    @Override
    public FundPlanSystem getFundSystem(long systemId) {
        return this.dimensionRepository.loadSystem(systemId);
    }
}

