/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.business.utils.DataSetUtil;

public abstract class AbstractUpgradeService<T>
implements IUpgradeService {
    protected final Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateData() {
        this.logger.info("updateData begin\uff1a");
        DataSet dataSet = this.getDataSet();
        if (dataSet == null) {
            return;
        }
        try {
            int batchSize = this.getBatchSize();
            int totalCount = 0;
            ArrayList<T> list = new ArrayList<T>(batchSize);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                list.add(this.convert(row));
                ++totalCount;
                if (list.size() != batchSize) continue;
                this.inTransaction(list, totalCount);
                list.clear();
            }
            if (EmptyUtil.isNoEmpty(list)) {
                this.inTransaction(list, totalCount);
            }
            this.logger.info("updateData end,total size:{}", (Object)totalCount);
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet(dataSet);
            throw throwable;
        }
        DataSetUtil.closeDataSet(dataSet);
    }

    private void inTransaction(List<T> list, int totalCount) {
        if (EmptyUtil.isEmpty(list)) {
            return;
        }
        int batchSize = this.getBatchSize();
        int batch = totalCount / batchSize;
        if (totalCount % batchSize != 0) {
            ++batch;
        }
        String message = "current total size: " + totalCount + ",the batch of " + batch + " will upgrade ,current batch size:" + list.size();
        this.logger.info(message);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.doUpgrade(list);
            }
            catch (Exception e) {
                this.logger.error(message + "has exception, message: " + e.getMessage(), (Throwable)e);
                txHandle.markRollback();
            }
        }
    }

    protected abstract void doUpgrade(List<T> var1);

    abstract T convert(Row var1);

    abstract DataSet getDataSet();

    protected int getBatchSize() {
        return 1000;
    }
}

