/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.common.enums.DetailDimTypeEnum;

public class DetailExtraFieldsUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DetailExtraFieldsUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        logger.info("[DetailExtraFieldsUpgradeServiceImpl] >>>> \u81ea\u5b9a\u4e49\u5b57\u6bb5\u6269\u5c55\u5347\u7ea7\u4efb\u52a1\u5f00\u59cb... ");
        String selectProp = String.join((CharSequence)",", "bodysys", "detaildimtype");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_detailplanfields", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("detaildimtype", "like", (Object)"EXTRA_%")});
        Map<Long, Long> systemExtraFieldsCountMap = dynamicObjectCollection.stream().collect(Collectors.groupingBy(dy -> dy.getLong("bodysys"), Collectors.counting()));
        ArrayList needUpgradeSystemIdList = new ArrayList(systemExtraFieldsCountMap.size());
        systemExtraFieldsCountMap.forEach((k, v) -> {
            if (v < 16L) {
                needUpgradeSystemIdList.add(k);
            }
        });
        if (needUpgradeSystemIdList.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(needUpgradeSystemIdList.size() * 8);
        DynamicObject[] bodySystemDynamicObjects = TmcDataServiceHelper.load((String)"fpm_bodysysmanage", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", needUpgradeSystemIdList)});
        String userId = RequestContext.get().getUserId();
        Date date = new Date();
        for (DynamicObject system : bodySystemDynamicObjects) {
            int sort = 17;
            for (int i = 9; i < 17; ++i) {
                DynamicObject newObj = TmcDataServiceHelper.newDynamicObject((String)"fpm_detailplanfields");
                newObj.set("bodysys", (Object)system);
                newObj.set("createtime", (Object)date);
                newObj.set("creator", (Object)userId);
                newObj.set("enable", (Object)BaseEnableEnum.ENABLE.getValue());
                newObj.set("status", (Object)BillStatusEnum.AUDIT.getValue());
                newObj.set("sort", (Object)sort);
                newObj.set("modifytime", (Object)date);
                newObj.set("modifier", (Object)userId);
                String typeNumber = "EXTRA_" + i;
                newObj.set("syssetpre", (Object)Boolean.FALSE);
                DetailDimTypeEnum extraDetailType = DetailDimTypeEnum.getByValue((String)typeNumber);
                newObj.set("fieldname", (Object)extraDetailType.getName());
                newObj.set("detaildimtype", (Object)extraDetailType.getValue());
                dataList.add(newObj);
                ++sort;
            }
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_detailplanfields", (DynamicObject[])dataList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        logger.info("[DetailExtraFieldsUpgradeServiceImpl] >>>> \u81ea\u5b9a\u4e49\u5b57\u6bb5\u6269\u5c55\u5347\u7ea7\u4efb\u52a1\u7ed3\u675f");
    }
}

