/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;

public class ExecutePlanRecordActUpdateUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ExecutePlanRecordActUpdateUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        LogStr logStr = new LogStr();
        logStr.appendLog("begin execute IUpgradeService" + this.getClass().getName());
        this.inTransaction(logStr);
        logStr.appendLog("end execute IUpgradeService" + this.getClass().getName());
    }

    protected void doUpgrade(LogStr logStr, List<ExecuteRecord> executeRecordList) {
        if (ExecutePlanRecordActUpdateUpgradeServiceImpl.isEmpty(executeRecordList)) {
            logger.info("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e\u3002");
            return;
        }
        List<Long> originalRecordIds = executeRecordList.stream().map(ExecuteRecord::getId).collect(Collectors.toList());
        List<ExecuteRecord> allReleaseRecordList = this.getReleaseRecordList(logStr, originalRecordIds);
        Map<Long, List<ExecuteRecord>> originalIdRecordMap = allReleaseRecordList.stream().collect(Collectors.groupingBy(ExecuteRecord::getOriginalRecordId));
        List actRecordList = executeRecordList.stream().filter(p -> Objects.equals(p.getPlanExecuteOp(), "A")).collect(Collectors.toList());
        if (ExecutePlanRecordActUpdateUpgradeServiceImpl.isEmpty(actRecordList)) {
            logger.info("\u6ca1\u6709\u53ef\u5347\u7ea7\u7684\u5b9e\u5360\u8bb0\u5f55\u3002");
            logStr.appendLog("no actual execute record.");
            return;
        }
        ArrayList<ExecuteRecord> updatedList = new ArrayList<ExecuteRecord>(actRecordList.size());
        for (ExecuteRecord executeRecord : actRecordList) {
            executeRecord.setAclRemainAmt(executeRecord.getRealAmt());
            updatedList.add(executeRecord);
            List<ExecuteRecord> releaseRecordList = originalIdRecordMap.get(executeRecord.getId());
            if (ExecutePlanRecordActUpdateUpgradeServiceImpl.isEmpty(releaseRecordList)) continue;
            releaseRecordList.sort(Comparator.comparing(ExecuteRecord::getCreateTime));
            releaseRecordList.forEach(releaseRecord -> {
                executeRecord.updateAclRemainAmt(releaseRecord.getRealAmt());
                releaseRecord.setAclRemainAmt(executeRecord.getAclRemainAmt());
                updatedList.add((ExecuteRecord)releaseRecord);
            });
        }
        this.batchUpdate("update t_fpm_executeplan set faclremainamt=? where fid=?", updatedList, (t, d) -> {
            d.add(t.getAclRemainAmt());
            d.add(t.getId());
        });
    }

    protected DataSet getDataSet(LogStr logStr) {
        if (QueryServiceHelper.exists((String)"fpm_executeplan", (QFilter[])new QFilter[]{new QFilter("planexecuteop", "=", (Object)PlanExecuteOpType.UPDATE.getValue())})) {
            logStr.appendLog("actual update ExecuteRecord is generated.");
            return null;
        }
        String sql = "select a.fid as fid,a.fbillno as fbillno,a.fplanexecuteop as fplanexecuteop,b.frelaterecordid as frelaterecordid,b.foriginalrecordid as foriginalrecordid,a.faclremainamt as faclremainamt,a.frealamt as frealamt,a.fcreatetime as fcreatetime from t_fpm_executeplan a left join t_fpm_executeplan_e b on a.fid=b.fid where a.fdeleteflag='0' and a.fplanexecuteop='A' and a.fexecuteoperatorstatus='C' ";
        logStr.appendLog(sql);
        return DB.queryDataSet((String)"ExecutePlanRecordActUpdateUpgradeServiceImpl", (DBRoute)DBRoute.of((String)"tmc"), (String)sql);
    }

    protected ExecuteRecord convert(Row row) {
        return new ExecuteRecord().setId(row.getLong("fid")).setBillNo(row.getString("fbillno")).setPlanExecuteOp(row.getString("fplanexecuteop")).setRelateRecordId(row.getLong("frelaterecordid")).setOriginalRecordId(row.getLong("foriginalrecordid")).setAclRemainAmt(row.getBigDecimal("faclremainamt")).setRealAmt(row.getBigDecimal("frealamt")).setCreateTime(row.getDate("fcreatetime"));
    }

    private List<ExecuteRecord> getReleaseRecordList(LogStr logStr, List<Long> originalRecordIds) {
        String selectFields = String.join((CharSequence)",", "id", "billno", "planexecuteop", "relaterecordid", "originalrecordid", "realamt", "createtime");
        QFilter qFilter = new QFilter("originalrecordid", "in", originalRecordIds).and(new QFilter("planexecuteop", "=", (Object)"F")).and(new QFilter("executeoperatorstatus", "=", (Object)"C")).and(new QFilter("deleteflag", "=", (Object)"0"));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_executeplan", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        List<ExecuteRecord> executeRecordList = this.convertDc(dynamicObjectCollection);
        logStr.appendLog("queried act release record size:" + executeRecordList.size());
        logger.info("\u67e5\u8be2\u6761\u4ef6\uff1a{}\uff0c\u67e5\u8be2\u5230\u7684\u5b9e\u5360\u8fd4\u8fd8\u8bb0\u5f55\u6761\u6570\uff1a{}", (Object)qFilter, (Object)executeRecordList.size());
        return executeRecordList;
    }

    private List<ExecuteRecord> convertDc(DynamicObjectCollection dynamicObjectCollection) {
        if (ExecutePlanRecordActUpdateUpgradeServiceImpl.isEmpty((Collection)dynamicObjectCollection)) {
            return Collections.emptyList();
        }
        return dynamicObjectCollection.stream().map(dy -> new ExecuteRecord().setId(dy.getLong("id")).setBillNo(dy.getString("billno")).setPlanExecuteOp(dy.getString("planexecuteop")).setRelateRecordId(dy.getLong("relaterecordid")).setOriginalRecordId(dy.getLong("originalrecordid")).setAclRemainAmt(BigDecimal.ZERO).setRealAmt(dy.getBigDecimal("realamt")).setCreateTime(dy.getDate("createtime"))).collect(Collectors.toList());
    }

    protected void doUpgrade(LogStr logStr) {
        try (DataSet dataSet = this.getDataSet(logStr);){
            if (dataSet == null) {
                return;
            }
            int totalSize = 0;
            int batchSize = this.getBatchSize();
            ArrayList<ExecuteRecord> dataList = new ArrayList<ExecuteRecord>(batchSize);
            while (dataSet.hasNext()) {
                ++totalSize;
                Row row = dataSet.next();
                dataList.add(this.convert(row));
                if (dataList.size() != batchSize) continue;
                this.inNewTransaction(logStr, totalSize, dataList);
                dataList.clear();
            }
            this.inNewTransaction(logStr, totalSize, dataList);
        }
    }

    protected void batchUpdate(String sql, List<ExecuteRecord> entityList, BiConsumer<ExecuteRecord, List<Object>> biConsumer) {
        if (ExecutePlanRecordActUpdateUpgradeServiceImpl.isEmpty(entityList)) {
            return;
        }
        ArrayList<Object[]> execParams = new ArrayList<Object[]>(entityList.size());
        int count = 0;
        int index = 0;
        while ((index = sql.indexOf("?", index)) != -1) {
            ++count;
            ++index;
        }
        for (ExecuteRecord t : entityList) {
            ArrayList list = new ArrayList(count);
            biConsumer.accept(t, list);
            execParams.add(list.toArray());
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"tmc"), (String)sql, execParams);
    }

    public void inNewTransaction(LogStr logStr, int totalSize, List<ExecuteRecord> dataList) {
        if (ExecutePlanRecordActUpdateUpgradeServiceImpl.isEmpty(dataList)) {
            return;
        }
        String message = "current total size: " + totalSize + ",the batch of " + totalSize / this.getBatchSize() + " will upgrade ,current batch size:" + dataList.size();
        logStr.appendLog(message);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.doUpgrade(logStr, dataList);
            }
            catch (Exception e) {
                logStr.appendErrorInfo(message + "has exception, message: " + e.getMessage() + "caused:" + ExecutePlanRecordActUpdateUpgradeServiceImpl.getStackTraceMessage(e));
                txHandle.markRollback();
            }
        }
    }

    protected int getBatchSize() {
        return 1000;
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    private void inTransaction(LogStr logStr) {
        try (TXHandle txHandle = TX.required();){
            try {
                this.doUpgrade(logStr);
            }
            catch (Exception e) {
                logStr.appendErrorInfo(e.getMessage() + "caused:" + ExecutePlanRecordActUpdateUpgradeServiceImpl.getStackTraceMessage(e));
                txHandle.markRollback();
            }
        }
    }

    public static String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    static class ExecuteRecord {
        private Long id;
        private String billNo;
        private String planExecuteOp;
        private Long relateRecordId;
        private Long originalRecordId;
        private BigDecimal aclRemainAmt;
        private BigDecimal realAmt;
        private Date createTime;

        ExecuteRecord() {
        }

        public Long getId() {
            return this.id;
        }

        public ExecuteRecord setId(Long id) {
            this.id = id;
            return this;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public ExecuteRecord setBillNo(String billNo) {
            this.billNo = billNo;
            return this;
        }

        public String getPlanExecuteOp() {
            return this.planExecuteOp;
        }

        public ExecuteRecord setPlanExecuteOp(String planExecuteOp) {
            this.planExecuteOp = planExecuteOp;
            return this;
        }

        public Long getRelateRecordId() {
            return this.relateRecordId;
        }

        public ExecuteRecord setRelateRecordId(Long relateRecordId) {
            this.relateRecordId = relateRecordId;
            return this;
        }

        public Long getOriginalRecordId() {
            return this.originalRecordId;
        }

        public ExecuteRecord setOriginalRecordId(Long originalRecordId) {
            this.originalRecordId = originalRecordId;
            return this;
        }

        public BigDecimal getAclRemainAmt() {
            return this.aclRemainAmt;
        }

        public ExecuteRecord setAclRemainAmt(BigDecimal aclRemainAmt) {
            this.aclRemainAmt = aclRemainAmt;
            return this;
        }

        public void updateAclRemainAmt(BigDecimal diffAmt) {
            if (diffAmt == null) {
                return;
            }
            this.aclRemainAmt = this.aclRemainAmt.add(diffAmt);
        }

        public BigDecimal getRealAmt() {
            return this.realAmt;
        }

        public ExecuteRecord setRealAmt(BigDecimal realAmt) {
            this.realAmt = realAmt;
            return this;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public ExecuteRecord setCreateTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }
    }

    protected static class LogStr {
        private Map<String, StringBuilder> messageMap = new HashMap<String, StringBuilder>(16);
        private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        private String el;
        private boolean success = true;

        public void appendErrorInfo(String message) {
            this.appendMessage(message, this.getStringBuilder("errorInfo"));
            this.success = false;
        }

        public void appendLog(String message) {
            this.appendMessage(message, this.getStringBuilder("log"));
        }

        public String getLog() {
            StringBuilder stringBuilder = this.messageMap.get("log");
            return Objects.isNull(stringBuilder) ? "" : stringBuilder.toString();
        }

        public String getErrorInfo() {
            StringBuilder stringBuilder = this.messageMap.get("errorInfo");
            return Objects.isNull(stringBuilder) ? "" : stringBuilder.toString();
        }

        public String getEl() {
            return this.el;
        }

        public void setEl(String el) {
            this.el = el;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        private StringBuilder getStringBuilder(String key) {
            return this.messageMap.computeIfAbsent(key, k -> new StringBuilder());
        }

        private void appendMessage(String message, StringBuilder stringBuilder) {
            stringBuilder.append(this.simpleDateFormat.format(new Date())).append("---").append(System.currentTimeMillis()).append("---").append(message).append("\r\n");
        }
    }
}

