/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.LRUCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.dataproc.save.impl.SyncShrekReportDataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.upgrade.DataResetConfig;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.business.mvc.service.control.factory.RelateReportDataManagerFactory;
import kd.tmc.fpm.business.mvc.service.control.factory.UpgradeConfigParserFactory;
import kd.tmc.fpm.business.mvc.service.upgrade.manage.DataResetManager;
import kd.tmc.fpm.business.service.rpc.param.IParam;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DataSetUtil;
import org.apache.commons.collections.CollectionUtils;

public class ExecutePlanRecordRecoverUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(ExecutePlanRecordRecoverUpgradeService.class);
    private IParam param;
    private IReportDataQueryService reportDataQueryService;
    private IDataSaveService dataSaveService;
    private DataResetConfig dataResetConfig;
    private DataResetManager dataResetManager;
    private LRUCache<Long, ReportData> lruCache = new LRUCache(1024);

    public ExecutePlanRecordRecoverUpgradeService(IParam param) {
        this.param = param;
        this.reportDataQueryService = new ReportDataQueryService();
        this.dataSaveService = new SyncShrekReportDataSaveServiceImpl(new DataSaveServiceImpl());
        this.dataResetConfig = (DataResetConfig)UpgradeConfigParserFactory.getConfigParser(this.param).parse(this.param);
        this.dataResetManager = new DataResetManager(this.dataResetConfig);
    }

    public ExecutePlanRecordRecoverUpgradeService(DataResetConfig dataResetConfig) {
        this.reportDataQueryService = new ReportDataQueryService();
        this.dataSaveService = new SyncShrekReportDataSaveServiceImpl(new DataSaveServiceImpl());
        this.dataResetConfig = dataResetConfig;
        this.dataResetManager = new DataResetManager(dataResetConfig);
    }

    @Override
    public void updateData() {
        DataSet dataSet = this.getDataSet();
        try {
            FpmOperateResult result = CommonUtils.processInTransactionRequiresNew(() -> {
                long total = 0L;
                int count = 0;
                ArrayList<PlanExecuteRecord> planExecuteRecordList = new ArrayList<PlanExecuteRecord>(10000);
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    PlanExecuteRecord convert = this.convert(next);
                    planExecuteRecordList.add(convert);
                    if (++count != this.dataResetConfig.getBatchSize()) continue;
                    this.doUpdate(planExecuteRecordList);
                    planExecuteRecordList.clear();
                    total += (long)count;
                    count = 0;
                }
                if (EmptyUtil.isNoEmpty(planExecuteRecordList)) {
                    total += (long)count;
                    this.doUpdate(planExecuteRecordList);
                }
                LOGGER.info("\u5df2\u5b8c\u6210\uff0c\u6267\u884c\u8bb0\u5f55\u603b\u6761\u6570\uff1a{}", (Object)total);
                return FpmOperateResult.success();
            });
            if (!result.isSuccess()) {
                throw new KDBizException(String.join((CharSequence)",", result.getMessageList()));
            }
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet(dataSet);
            throw throwable;
        }
        DataSetUtil.closeDataSet(dataSet);
    }

    private void doUpdate(List<PlanExecuteRecord> planExecuteRecordList) {
        Map<Long, Set<Long>> systemReportDataIdMap = planExecuteRecordList.stream().map(PlanExecuteRecord::getMatchedReportDataList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.groupingBy(ReportData::getSystemId, Collectors.mapping(ReportData::getId, Collectors.toSet())));
        List<ReportData> reportDataList = this.getReportDataList(systemReportDataIdMap);
        this.dataResetManager.clearAmt(reportDataList);
        Map<Long, ReportData> reportDataMap = reportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
        ControlAmountCache controlAmountCache = this.getControlAmountCache(reportDataList);
        this.updateControlAmountCache(planExecuteRecordList, reportDataMap, controlAmountCache);
        this.doUpdateData(reportDataMap, controlAmountCache);
    }

    private List<ReportData> getReportDataList(Map<Long, Set<Long>> systemReportDataIdMap) {
        ArrayList<ReportData> allReportDataList = new ArrayList<ReportData>(1024);
        for (Map.Entry<Long, Set<Long>> entry : systemReportDataIdMap.entrySet()) {
            ArrayList<Long> reportDataIdList = new ArrayList<Long>((Collection)entry.getValue());
            ArrayList<ReportData> cachedList = new ArrayList<ReportData>(reportDataIdList.size());
            HashSet cachedId = new HashSet(reportDataIdList.size());
            reportDataIdList.forEach(dataId -> {
                ReportData reportData = (ReportData)this.lruCache.get(dataId);
                if (Objects.nonNull(reportData)) {
                    cachedId.add(dataId);
                    cachedList.add(reportData);
                }
            });
            reportDataIdList.removeIf(cachedId::contains);
            if (EmptyUtil.isEmpty(reportDataIdList)) {
                return cachedList;
            }
            List<ReportData> reportDataList = this.reportDataQueryService.queryReportData(t -> {
                t.setIdList(reportDataIdList);
                t.setNeedDimIfValueIsNotEmpty(true);
            });
            reportDataList.addAll(cachedList);
            allReportDataList.addAll(reportDataList);
        }
        return allReportDataList;
    }

    private void updateControlAmountCache(List<PlanExecuteRecord> planExecuteRecordList, Map<Long, ReportData> reportDataMap, ControlAmountCache controlAmountCache) {
        for (PlanExecuteRecord planExecuteRecord : planExecuteRecordList) {
            BigDecimal reportActAmount = planExecuteRecord.getActAmount();
            List<ReportData> matchedReportDataList = planExecuteRecord.getMatchedReportDataList();
            PlanExecuteOpType executeOpType = planExecuteRecord.getExecuteOpType();
            if (this.dataResetConfig.isDetailLog()) {
                LOGGER.info("\u6267\u884c\u8bb0\u5f55\uff1a{}\uff0c\u6267\u884c\u64cd\u4f5c\uff1a{}\uff0c\u6267\u884c\u989d\u5ea6\uff1a{}", new Object[]{planExecuteRecord.getRecordNumber(), planExecuteRecord.getExecuteOpType(), reportActAmount});
            }
            for (ReportData reportData : matchedReportDataList) {
                ReportData rd = reportDataMap.get(reportData.getId());
                if (executeOpType == PlanExecuteOpType.PRE_OCCUPY_WRITE || executeOpType == PlanExecuteOpType.PRE_OCCUPY_RELEASE) {
                    controlAmountCache.updateLockAmount(rd.getId(), rd.getReportActAmount(reportActAmount));
                    if (!this.dataResetConfig.isDetailLog()) continue;
                    LOGGER.info("\u7f16\u5236\u6570\u636eid\uff1a{},\u7f13\u5b58\u989d\u5ea6\uff1a{}", (Object)rd.getId(), (Object)controlAmountCache.getAvailableLockAmt(rd.getId()));
                    continue;
                }
                if (executeOpType != PlanExecuteOpType.WRITE && executeOpType != PlanExecuteOpType.RELEASE && executeOpType != PlanExecuteOpType.UPDATE) continue;
                controlAmountCache.updateActAmount(rd.getId(), rd.getReportActAmount(reportActAmount));
                if (!this.dataResetConfig.isDetailLog()) continue;
                LOGGER.info("\u7f16\u5236\u6570\u636eid\uff1a{},\u7f13\u5b58\u989d\u5ea6\uff1a{}", (Object)rd.getId(), (Object)controlAmountCache.getAvailableActAmt(rd.getId()));
            }
        }
    }

    private ControlAmountCache getControlAmountCache(List<ReportData> reportDataList) {
        Map<Long, List<ReportData>> systemReportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getSystemId));
        ControlAmountCache controlAmountCache = new ControlAmountCache();
        for (Map.Entry<Long, List<ReportData>> entry : systemReportDataMap.entrySet()) {
            controlAmountCache.init(entry.getValue(), entry.getKey());
        }
        return controlAmountCache;
    }

    private void doUpdateData(Map<Long, ReportData> reportDataMap, ControlAmountCache controlAmountCache) {
        List<ControlAmountCache.AmountInfo> updateAmountInfoList = controlAmountCache.getUpdateData();
        if (this.dataResetConfig.isDetailLog()) {
            LOGGER.info("updateAmountInfoList:{}", updateAmountInfoList);
        }
        List<ReportData> needUpdateReportDataList = updateAmountInfoList.stream().map(ControlAmountCache.AmountInfo::getReportDataId).map(reportDataMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        IRelateReportDataManager relateReportDataManager = RelateReportDataManagerFactory.getRelateReportDataManager(needUpdateReportDataList);
        Map amountInfoMap = updateAmountInfoList.stream().collect(Collectors.toMap(ControlAmountCache.AmountInfo::getReportDataId, Function.identity(), (a, b) -> a));
        for (ReportData reportData : needUpdateReportDataList) {
            ControlAmountCache.AmountInfo amountInfo = (ControlAmountCache.AmountInfo)amountInfoMap.get(reportData.getId());
            reportData.addLockAmt(amountInfo.getLockDiffAmt());
            reportData.addActAmt(amountInfo.getActDiffAmt());
        }
        if (this.dataResetConfig.isDetailLog()) {
            LOGGER.info("\u83b7\u53d6\u5173\u8054\u6570\u636e\u7ba1\u7406\u5668\uff0c\u6570\u636e\u5927\u5c0f\uff1a{}\uff0c\uff1a{}", (Object)needUpdateReportDataList.size(), needUpdateReportDataList.stream().map(rd -> String.join((CharSequence)",", rd.getId().toString(), rd.getLockAmt().toPlainString(), rd.getActAmt().toPlainString())).collect(Collectors.toList()));
        }
        List<ReportData> relateReportDataListBySource = relateReportDataManager.getRelateReportDataListBySourceCanDiff(needUpdateReportDataList);
        relateReportDataListBySource.addAll(needUpdateReportDataList);
        List<ReportData> reportDataList = relateReportDataManager.reCalculateRelateDataByDAGAndCompletionIndex(relateReportDataListBySource);
        if (this.dataResetConfig.isDetailLog()) {
            LOGGER.info("\u91cd\u7b97DAG\u540e\u7684\u6570\u636e\u7ed3\u679c\uff0c\u6570\u636e\u5927\u5c0f\uff1a{}\uff0c\uff1a{}", (Object)reportDataList.size(), reportDataList.stream().map(rd -> String.join((CharSequence)",", rd.getId().toString(), rd.getLockAmt().toPlainString(), rd.getActAmt().toPlainString())).collect(Collectors.toList()));
        }
        reportDataList.addAll(needUpdateReportDataList);
        if (this.dataResetConfig.isDetailLog()) {
            LOGGER.info("\u91cd\u7b97DAG\u540e\u7684\u6240\u6709\u6570\u636e\u7ed3\u679c\uff0c\u6570\u636e\u5927\u5c0f\uff1a{}\uff0c\uff1a{}", (Object)reportDataList.size(), reportDataList.stream().map(rd -> String.join((CharSequence)",", rd.getId().toString(), rd.getLockAmt().toPlainString(), rd.getActAmt().toPlainString())).collect(Collectors.toList()));
        }
        reportDataList.forEach(rd -> {
            ReportData cfr_ignored_0 = (ReportData)this.lruCache.put((Object)rd.getId(), rd);
        });
        this.updateDataBase(reportDataList);
    }

    private void updateDataBase(List<ReportData> updateData) {
        FpmOperateResult result = CommonUtils.processInTransaction(() -> {
            this.dataResetManager.resetData(updateData);
            this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_reportdatamain set flockamt=? ,frealamt=? where fentryid=?", updateData, (t, d) -> {
                d.add(t.getLockAmt());
                d.add(t.getActAmt());
                d.add(t.getId());
            });
            return FpmOperateResult.success();
        });
        if (!result.isSuccess()) {
            throw new KDBizException(String.join((CharSequence)",", result.getMessageList()));
        }
    }

    private DataSet getDataSet() {
        String selectFields = String.join((CharSequence)",", "id", "bodysys.id", "billno", "createtime", "relaterecordid", "originalrecordid", "bizbillid", "reportdataid", "matchedreportdataids", "rate", "realamt", "planexecuteop");
        QFilter qFilter = new QFilter("deleteflag", "=", (Object)"0").and("executeoperatorstatus", "=", (Object)PlanExecuteStatus.SUCCESSFUL.getValue());
        if (EmptyUtil.isNoEmpty(this.dataResetConfig.getSystemIds())) {
            qFilter = qFilter.and("bodysys.id", "in", this.dataResetConfig.getSystemIds());
        }
        if (EmptyUtil.isNoEmpty(this.dataResetConfig.getBillIds())) {
            qFilter = qFilter.and("bizbillid", "in", this.dataResetConfig.getBillIds());
        }
        if (EmptyUtil.isNoEmpty(this.dataResetConfig.getReportTypeIds())) {
            qFilter = qFilter.and("reporttype.id", "in", this.dataResetConfig.getReportTypeIds());
        }
        qFilter = CollectionUtils.isNotEmpty(this.dataResetConfig.getPeriodSet()) ? qFilter.and("reportperiod", "in", this.dataResetConfig.getPeriodSet()) : qFilter.and("createtime", ">=", (Object)this.dataResetConfig.getStartDate()).and("createtime", "<=", (Object)this.dataResetConfig.getEndDate());
        LOGGER.info("\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)qFilter);
        return QueryServiceHelper.queryDataSet((String)"queryExecutePlanRecord", (String)"fpm_executeplan", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"createtime");
    }

    public PlanExecuteRecord convert(Row row) {
        PlanExecuteRecord planExecuteRecord = new PlanExecuteRecord();
        planExecuteRecord.setId(row.getLong("id"));
        planExecuteRecord.setRecordNumber(row.getString("billno"));
        planExecuteRecord.setRelateRecordId(row.getLong("relaterecordid"));
        planExecuteRecord.setOriginalRecordId(row.getLong("originalrecordid"));
        planExecuteRecord.setRate(row.getBigDecimal("rate"));
        planExecuteRecord.setActAmount(row.getBigDecimal("realamt"));
        planExecuteRecord.setExecuteOpType(ITypeEnum.getByNumber(row.getString("planexecuteop"), PlanExecuteOpType.class));
        planExecuteRecord.setSystemId(row.getLong("bodysys.id"));
        BillBizInfo billBizInfo = new BillBizInfo();
        billBizInfo.setBillId(row.getLong("bizbillid"));
        planExecuteRecord.setBillBizInfo(billBizInfo);
        ReportData reportData = new ReportData();
        reportData.setId(row.getLong("reportdataid"));
        String reportDataIds = row.getString("matchedreportdataids");
        String[] split = reportDataIds.split(",");
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(split.length);
        for (String reportDataId : split) {
            ReportData rd = new ReportData();
            long id = Long.parseLong(reportDataId);
            rd.setId(id);
            rd.setSystemId(planExecuteRecord.getSystemId());
            reportDataList.add(rd);
        }
        planExecuteRecord.setMatchedReportDataList(CommonUtils.getDistinctList(reportDataList, ReportData::getId));
        return planExecuteRecord;
    }
}

