/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class TemplateSubjectFlowTotalUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TemplateSubjectFlowTotalUpgradeServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result;
        block22: {
            result = new UpgradeResult();
            result.setEl("warning");
            long beginTime = System.currentTimeMillis();
            boolean withExc = false;
            try (TXHandle txHandle = TX.requiresNew();){
                long endTime;
                try {
                    result.setLog("start upgrade... ");
                    this.upgradeTemplate();
                    result.setLog("end upgrade... ");
                }
                catch (Exception e) {
                    try {
                        withExc = true;
                        result.setErrorInfo(e.getMessage());
                        result.setSuccess(false);
                        logger.info(e.getMessage());
                        logger.info(result.getErrorInfo());
                    }
                    catch (Throwable throwable) {
                        long endTime2 = System.currentTimeMillis();
                        if (withExc) {
                            result.setLog(String.format("TemplateSubjectFlowTotalUpgradeService Exception take up time \uff1a%sms", endTime2 - beginTime));
                        } else {
                            result.setLog(String.format("TemplateSubjectFlowTotalUpgradeService no Exception take up time \uff1a%sms", endTime2 - beginTime));
                        }
                        throw throwable;
                    }
                    endTime = System.currentTimeMillis();
                    if (withExc) {
                        result.setLog(String.format("TemplateSubjectFlowTotalUpgradeService Exception take up time \uff1a%sms", endTime - beginTime));
                    } else {
                        result.setLog(String.format("TemplateSubjectFlowTotalUpgradeService no Exception take up time \uff1a%sms", endTime - beginTime));
                    }
                    break block22;
                }
                endTime = System.currentTimeMillis();
                if (withExc) {
                    result.setLog(String.format("TemplateSubjectFlowTotalUpgradeService Exception take up time \uff1a%sms", endTime - beginTime));
                } else {
                    result.setLog(String.format("TemplateSubjectFlowTotalUpgradeService no Exception take up time \uff1a%sms", endTime - beginTime));
                }
            }
        }
        return result;
    }

    public void upgradeTemplate() {
        String queryNoExpendSubjectSql = "select distinct a.fid from t_fpm_template_dimset a, t_fpm_dimadd b where a.fdimid = b.fid and a.fdimbdtype = 'fpm_dimension' and b.fbasedata  = 'Subjects' and (a.fisopen  = '1' or a.ftype = 'page') and a.fid in (%s)";
        String queryOpenTotalsSql = "select distinct a.fid from t_fpm_template_dimset a where a.ftotalrow = '1' and a.fid in (%s)";
        String querySubjectCol = "select distinct a.fid, a.fentryid from t_fpm_template_dimset a, t_fpm_dimadd b where a.fdimid = b.fid and a.fdimbdtype = 'fpm_dimension' and b.fbasedata  = 'Subjects'  and a.fid in (%s)";
        long maxId = 0L;
        String querySql = "select top 100 fid  from t_fpm_templateinfo where fid > ? and ftemplatetype = 'DET' order by fid";
        while (true) {
            DataSet template = DB.queryDataSet((String)"selectTemplate", (DBRoute)DBRouteConst.TMC, (String)querySql, (Object[])new Object[]{maxId});
            Throwable throwable = null;
            try {
                Set<Long> totalRowOpenTemplateId;
                if (template.isEmpty()) {
                    logger.info("TemplateSubjectFlowTotalUpgradeService template update end");
                    break;
                }
                ArrayList<Long> templateIds = new ArrayList<Long>(16);
                while (template.hasNext()) {
                    Row next = template.next();
                    Long fid = next.getLong("fid");
                    maxId = Math.max(fid, maxId);
                    templateIds.add(fid);
                }
                if (templateIds.isEmpty()) {
                    logger.info("TemplateSubjectFlowTotalUpgradeService template update end");
                    break;
                }
                Set<Long> subjectOpenTemplateId = this.checkSubjectOpen(queryNoExpendSubjectSql, templateIds);
                if (!CollectionUtils.isEmpty(subjectOpenTemplateId)) {
                    templateIds.removeIf(subjectOpenTemplateId::contains);
                    if (CollectionUtils.isEmpty(templateIds)) continue;
                }
                if (CollectionUtils.isEmpty(totalRowOpenTemplateId = this.checkTotalRowOpen(queryOpenTotalsSql, templateIds))) continue;
                templateIds.removeIf(i -> !totalRowOpenTemplateId.contains(i));
                if (CollectionUtils.isEmpty(templateIds)) continue;
                this.updateTotalRows(querySubjectCol, templateIds);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (template == null) continue;
                if (throwable != null) {
                    try {
                        template.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                template.close();
                continue;
            }
            break;
        }
    }

    private void updateTotalRows(String querySubjectCol, List<Long> templateIds) {
        String queryTemplateIdAndEntryId = String.format(querySubjectCol, templateIds.stream().map(Object::toString).collect(Collectors.joining(",")));
        try (DataSet templateIdAndEntryId = DB.queryDataSet((String)"queryTemplateIdAndEntryId", (DBRoute)DBRouteConst.TMC, (String)queryTemplateIdAndEntryId);){
            HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>(16);
            while (templateIdAndEntryId.hasNext()) {
                Row checkIsOpenRow = templateIdAndEntryId.next();
                Long id = checkIsOpenRow.getLong("fid");
                Long entryId = checkIsOpenRow.getLong("fentryid");
                if (!Objects.nonNull(id) || !Objects.nonNull(entryId)) continue;
                entryIdMap.put(id, entryId);
            }
            try (TXHandle h = TX.requiresNew((String)"delTipsData");){
                try {
                    String sql = "update t_fpm_template_dimset set fsubjectflowtotal=1 where fid=? and fentryid = ? ";
                    ArrayList<Object[]> list = new ArrayList<Object[]>(10);
                    for (Map.Entry entry : entryIdMap.entrySet()) {
                        Object[] param = new Object[]{entry.getKey(), entry.getValue()};
                        list.add(param);
                    }
                    DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, list);
                }
                catch (Exception e) {
                    h.markRollback();
                    logger.error("TemplateSubjectFlowTotalUpgradeService template update error", (Throwable)e);
                }
            }
        }
    }

    private Set<Long> checkSubjectOpen(String queryNoExpendSubjectSql, List<Long> idList) {
        HashSet<Long> result = new HashSet<Long>(idList.size());
        String formatSql = String.format(queryNoExpendSubjectSql, idList.stream().map(Object::toString).collect(Collectors.joining(",")));
        try (DataSet checkSubjectIsOpen = DB.queryDataSet((String)"checkSubjectIsOpen", (DBRoute)DBRouteConst.TMC, (String)formatSql);){
            while (checkSubjectIsOpen.hasNext()) {
                Row checkIsOpenRow = checkSubjectIsOpen.next();
                Long id = checkIsOpenRow.getLong("fid");
                result.add(id);
            }
        }
        return result;
    }

    private Set<Long> checkTotalRowOpen(String queryCheckTotalRowOpenSql, List<Long> idList) {
        HashSet<Long> result = new HashSet<Long>(idList.size());
        String formatSql = String.format(queryCheckTotalRowOpenSql, idList.stream().map(Object::toString).collect(Collectors.joining(",")));
        try (DataSet checkTotalRowOpen = DB.queryDataSet((String)"checkTotalRowOpen", (DBRoute)DBRouteConst.TMC, (String)formatSql);){
            while (checkTotalRowOpen.hasNext()) {
                Row checkIsOpenRow = checkTotalRowOpen.next();
                Long id = checkIsOpenRow.getLong("fid");
                result.add(id);
            }
        }
        return result;
    }
}

