/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.mvc.service.upgrade.AbstractUpgradeService;
import kd.tmc.fpm.business.utils.ListHelper;

public class ZeroReportUpgradeServiceImpl
extends AbstractUpgradeService<ReportInfo> {
    private static final IDataSaveService dataSaveService = new DataSaveServiceImpl();

    @Override
    protected void doUpgrade(List<ReportInfo> list) {
        for (ReportInfo reportInfo : list) {
            String conditionField = Objects.equals(BillStatus.COMMITTED.getNumber(), reportInfo.status) ? "maindimentry.planamt" : "maindimentry.reportplanamt";
            QFilter qFilter = new QFilter("id", "=", (Object)reportInfo.reportId).and(new QFilter("maindimentry.entryreportperiod", "=", (Object)reportInfo.reportPeriodId)).and(conditionField, "!=", (Object)BigDecimal.ZERO);
            boolean exists = QueryServiceHelper.exists((String)"fpm_report", (QFilter[])new QFilter[]{qFilter});
            if (exists) continue;
            dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fzeroreport='1' where fid=? and fzeroreport='0'", Collections.singletonList(reportInfo), (t, d) -> d.add(((ReportInfo)t).reportId));
        }
    }

    @Override
    ReportInfo convert(Row row) {
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.reportId = row.getLong("id");
        reportInfo.reportPeriodId = row.getLong("reportperiod");
        reportInfo.status = row.getString("billstatus");
        return reportInfo;
    }

    @Override
    DataSet getDataSet() {
        String templateUseProp = String.join((CharSequence)".", "template", "templateuses");
        QFilter qFilter = new QFilter("zeroreport", "=", (Object)Boolean.FALSE).and(new QFilter("billstatus", "in", ListHelper.asList(BillStatus.AUDITED.getNumber(), BillStatus.COMMITTED.getNumber()))).and(new QFilter(templateUseProp, "=", (Object)TemplateUseType.PLANING.getNumber()));
        return QueryServiceHelper.queryDataSet((String)"ZeroReportUpgradeServiceImpl.getDataSet", (String)"fpm_report", (String)String.join((CharSequence)",", "id", "reportperiod", "billstatus"), (QFilter[])new QFilter[]{qFilter}, null);
    }

    static class ReportInfo {
        private Long reportId;
        private Long reportPeriodId;
        private String status;

        ReportInfo() {
        }
    }
}

