/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade.manage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.SyncShrekReportDataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodDirection;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.upgrade.DataResetConfig;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class DataResetManager {
    private static final Log logger = LogFactory.getLog(DataResetManager.class);
    private Set<Long> periodStartMemberIds;
    private Set<Long> resetZeroReportDataIds;
    private DataResetConfig dataResetConfig;
    private IDataSaveService dataSaveService;

    public DataResetManager(DataResetConfig dataResetConfig) {
        this.dataResetConfig = dataResetConfig;
        this.periodStartMemberIds = new HashSet<Long>(512);
        this.resetZeroReportDataIds = new HashSet<Long>(4096);
        this.dataSaveService = new SyncShrekReportDataSaveServiceImpl(FpmServiceFactory.getBizService(IDataSaveService.class));
        this.init();
    }

    private void init() {
        if (this.dataResetConfig.isIgnorePeriodStartEnd()) {
            return;
        }
        HashSet<String> periodMarks = new HashSet<String>(4);
        periodMarks.add(PeriodDirection.BEGINNING.getNumber());
        QFilter filter = new QFilter("dimtype", "=", (Object)DimensionType.SUBJECTS.getNumber()).and("beginorendmark", "in", periodMarks);
        if (EmptyUtil.isNoEmpty(this.dataResetConfig.getSystemIds())) {
            filter = filter.and("bodysysmanage.id", "in", this.dataResetConfig.getSystemIds());
        }
        logger.info("\u671f\u521d\u671f\u672b\u79d1\u76ee\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)filter);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{filter});
        this.periodStartMemberIds.addAll(query.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
    }

    public void resetData(List<ReportData> reportDataList) {
        if (!this.dataResetConfig.isResetData()) {
            return;
        }
        Set dataIds = reportDataList.stream().map(ReportData::getId).filter(id -> !this.resetZeroReportDataIds.contains(id)).collect(Collectors.toSet());
        this.resetZeroReportDataIds.addAll(dataIds);
        ArrayList periodEndDataIds = new ArrayList(128);
        reportDataList.forEach(rd -> {
            if (!dataIds.contains(rd.getId())) {
                return;
            }
            Object subjectMemberId = rd.getDimValByDimType(DimensionType.SUBJECTS);
            if (this.periodStartMemberIds.contains(subjectMemberId)) {
                periodEndDataIds.add(rd.getId());
            }
        });
        if (!this.dataResetConfig.isIgnorePeriodStartEnd()) {
            periodEndDataIds.forEach(dataIds::remove);
        }
        if (this.dataResetConfig.isDetailLog()) {
            logger.info("\u66f4\u65b0\u6570\u636e\u5e93\u989d\u5ea6\u4e3a0\uff0c{}", dataIds);
        }
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_reportdatamain set flockamt=0 ,fholdlockamt=0,frealamt=0,fholdrealamt=0 where fentryid =?", new ArrayList(dataIds), (t, d) -> d.add(t));
        if (this.dataResetConfig.isIgnorePeriodStartEnd()) {
            return;
        }
        if (this.dataResetConfig.isDetailLog()) {
            logger.info("\u66f4\u65b0\u671f\u521d\u989d\u5ea6\u4e3a0\uff0c\u4e0d\u66f4\u65b0\u5b9e\u9645\u6570\uff1a{}", periodEndDataIds);
        }
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_reportdatamain set flockamt=0 ,fholdlockamt=0,fholdrealamt=0 where fentryid =?", new ArrayList(periodEndDataIds), (t, d) -> d.add(t));
    }

    public void clearAmt(List<ReportData> reportDataList) {
        if (!this.dataResetConfig.isResetData()) {
            return;
        }
        DetailLog<ReportData> detailLog = new DetailLog<ReportData>(this.dataResetConfig, rd -> rd.getId().toString());
        for (ReportData reportData : reportDataList) {
            if (this.periodStartMemberIds.contains(reportData.getDimValByDimType(DimensionType.SUBJECTS))) {
                detailLog.addItem("periodStartMemberIds", reportData);
                return;
            }
            if (this.resetZeroReportDataIds.contains(reportData.getId())) {
                detailLog.addItem("resetZeroReportDataIds", reportData);
                continue;
            }
            detailLog.addItem("clearAmt", reportData);
            reportData.clearAmt();
        }
        detailLog.print();
    }

    public static class DetailLog<T> {
        private Map<String, List<T>> detailMap = new HashMap<String, List<T>>(16);
        private Function<T, String> logPrint;
        private DataResetConfig dataResetConfig;

        public DetailLog(DataResetConfig dataResetConfig) {
            this(dataResetConfig, null);
        }

        public DetailLog(DataResetConfig dataResetConfig, Function<T, String> function) {
            this.logPrint = function;
            this.dataResetConfig = dataResetConfig;
            if (Objects.isNull(this.logPrint)) {
                this.logPrint = Objects::toString;
            }
        }

        public void addItem(String name, T item) {
            if (!this.dataResetConfig.isDetailLog()) {
                return;
            }
            List ts = this.detailMap.computeIfAbsent(name, k -> new ArrayList(16));
            ts.add(item);
        }

        public void print() {
            if (!this.dataResetConfig.isDetailLog()) {
                return;
            }
            for (Map.Entry<String, List<T>> entry : this.detailMap.entrySet()) {
                String key = entry.getKey();
                List<T> value = entry.getValue();
                logger.info("{},{}", (Object)key, value.stream().map(this.logPrint).collect(Collectors.toList()));
            }
        }
    }
}

