/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade.parser.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.upgrade.DataResetConfig;
import kd.tmc.fpm.business.mvc.service.upgrade.parser.IConfigParser;
import kd.tmc.fpm.business.service.rpc.param.IParam;
import kd.tmc.fpm.common.helper.StringHelper;

public class DataResetConfigParser
implements IConfigParser<DataResetConfig> {
    @Override
    public DataResetConfig parse(IParam param) {
        DataResetConfig dataResetConfig = new DataResetConfig();
        dataResetConfig.setStartDate(this.getStartDate(param));
        dataResetConfig.setEndDate(this.getEndDate(param));
        this.initSystemInfo(dataResetConfig, param);
        this.initBillId(dataResetConfig, param);
        this.initBatchSize(dataResetConfig, param);
        this.initReportTypeId(dataResetConfig, param);
        this.initOther(dataResetConfig, param);
        return dataResetConfig;
    }

    private void initReportTypeId(DataResetConfig dataResetConfig, IParam param) {
        Map<String, String> upgradeParamMap = param.getUpgradeParamMap();
        String reportTypeIds = upgradeParamMap.get("reportType");
        if (EmptyUtil.isEmpty((String)reportTypeIds)) {
            return;
        }
        String[] split = reportTypeIds.split(",");
        HashSet<String> reportTypeNumber = new HashSet<String>(split.length);
        for (String rtId : split) {
            try {
                long reportTypeId = Long.parseLong(rtId);
                dataResetConfig.addReportTypeId(reportTypeId);
            }
            catch (Exception e) {
                reportTypeNumber.add(rtId);
            }
        }
        if (EmptyUtil.isNoEmpty(reportTypeNumber)) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_orgreporttype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", reportTypeNumber)});
            query.stream().map(dy -> dy.getLong("id")).forEach(dataResetConfig::addReportTypeId);
        }
    }

    private void initOther(DataResetConfig dataResetConfig, IParam param) {
        Map<String, String> upgradeParamMap = param.getUpgradeParamMap();
        String ignore = upgradeParamMap.get("ignore");
        dataResetConfig.setIgnorePeriodStartEnd("true".equalsIgnoreCase(StringHelper.getStringValue((Object)ignore)));
        dataResetConfig.setResetData("true".equalsIgnoreCase(StringHelper.getStringValue((Object)upgradeParamMap.get("reset"))));
        dataResetConfig.setDetailLog("true".equalsIgnoreCase(StringHelper.getStringValue((Object)upgradeParamMap.get("logger"))));
    }

    private void initBatchSize(DataResetConfig dataResetConfig, IParam param) {
        Map<String, String> upgradeParamMap = param.getUpgradeParamMap();
        String batchSizeStr = upgradeParamMap.get("batchSize");
        int batchSize = 10000;
        if (Objects.nonNull(batchSizeStr)) {
            try {
                batchSize = Integer.parseInt(batchSizeStr);
                if (batchSize <= 0) {
                    batchSize = Integer.MAX_VALUE;
                }
            }
            catch (Exception e) {
                batchSize = Integer.MAX_VALUE;
            }
        }
        dataResetConfig.setBatchSize(batchSize);
    }

    private void initSystemInfo(DataResetConfig dataResetConfig, IParam param) {
        Map<String, String> upgradeParamMap = param.getUpgradeParamMap();
        String systems = upgradeParamMap.get("system");
        if (EmptyUtil.isEmpty((String)systems)) {
            return;
        }
        String[] split = systems.split(",");
        HashSet<String> systemNo = new HashSet<String>(split.length);
        for (String system : split) {
            try {
                long systemId = Long.parseLong(system);
                dataResetConfig.addSystemId(systemId);
            }
            catch (Exception e) {
                systemNo.add(system);
            }
        }
        if (EmptyUtil.isNoEmpty(systemNo)) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", systemNo)});
            query.stream().map(dy -> dy.getLong("id")).forEach(dataResetConfig::addSystemId);
        }
    }

    private void initBillId(DataResetConfig dataResetConfig, IParam param) {
        String[] split;
        Map<String, String> upgradeParamMap = param.getUpgradeParamMap();
        String billIds = upgradeParamMap.get("bill");
        if (EmptyUtil.isEmpty((String)billIds)) {
            return;
        }
        for (String billId : split = billIds.split(",")) {
            try {
                dataResetConfig.addBillId(Long.parseLong(billId));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Date getStartDate(IParam param) {
        Map<String, String> upgradeParamMap = param.getUpgradeParamMap();
        String start = upgradeParamMap.get("startDate");
        if (Objects.isNull(start)) {
            throw new KDBizException("startDate is empty");
        }
        Date startDate = DateUtils.stringToDate((String)start, (String)"yyyy-MM-dd");
        if (Objects.isNull(startDate)) {
            throw new KDBizException("startDate is date string");
        }
        String stringDate = DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00";
        startDate = DateUtils.stringToDate((String)stringDate, (String)"yyyy-MM-dd hh:mm:ss");
        return startDate;
    }

    private Date getEndDate(IParam param) {
        Map<String, String> upgradeParamMap = param.getUpgradeParamMap();
        String end = upgradeParamMap.get("endDate");
        if (Objects.isNull(end)) {
            throw new KDBizException("endDate is empty");
        }
        Date endDate = DateUtils.stringToDate((String)end, (String)"yyyy-MM-dd");
        if (Objects.isNull(endDate)) {
            throw new KDBizException("endDate is not date string");
        }
        String endStringDate = DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59";
        endDate = DateUtils.stringToDate((String)endStringDate, (String)"yyyy-MM-dd hh:mm:ss");
        return endDate;
    }
}

