/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.basesetting;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class DetailPlanFieldSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        DynamicObject data = dynamicObjects[0];
        DynamicObject model = data.getDynamicObject("bodysys");
        DynamicObjectCollection fieldInfoColl = data.getDynamicObjectCollection("entryentity");
        if (fieldInfoColl.size() > 0) {
            List idList = fieldInfoColl.stream().filter(e -> e.get("fieldbd") != null).map(e -> e.getDynamicObject("fieldbd").getPkValue()).collect(Collectors.toList());
            DynamicObject[] dbDataArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_detailplanfields"));
            Map dbDataMap = Stream.of(dbDataArr).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
            ArrayList<DynamicObject> finalData = new ArrayList<DynamicObject>(fieldInfoColl.size());
            for (int i = 0; i < fieldInfoColl.size(); ++i) {
                DynamicObject fieldInfo = (DynamicObject)fieldInfoColl.get(i);
                Object bdObj = fieldInfo.get("fieldbd");
                DynamicObject newObj = null;
                if (bdObj != null) {
                    newObj = (DynamicObject)dbDataMap.get(((DynamicObject)bdObj).getPkValue());
                } else {
                    newObj = TmcDataServiceHelper.newDynamicObject((String)"fpm_detailplanfields");
                    newObj.set("createtime", (Object)new Date());
                    newObj.set("creator", (Object)RequestContext.get().getUserId());
                    newObj.set("enable", (Object)"1");
                    newObj.set("status", (Object)BillStatusEnum.AUDIT.getValue());
                }
                newObj.set("bodysys", (Object)model);
                newObj.set("fieldname", fieldInfo.get("fieldname"));
                newObj.set("detaildimtype", fieldInfo.get("detaildimtype"));
                newObj.set("name", fieldInfo.get("fieldshowname"));
                newObj.set("syssetpre", fieldInfo.get("syssetpre"));
                newObj.set("datatype", fieldInfo.get("datatype"));
                newObj.set("option", fieldInfo.get("option"));
                newObj.set("isshow", fieldInfo.get("isshow"));
                newObj.set("ismustinput", fieldInfo.get("ismustinput"));
                newObj.set("basedatatype", fieldInfo.get("basedatatype"));
                newObj.set("sort", (Object)(i + 1));
                newObj.set("modifytime", (Object)new Date());
                newObj.set("modifier", (Object)RequestContext.get().getUserId());
                finalData.add(newObj);
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_detailplanfields", (DynamicObject[])finalData.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }
}

