/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.basesetting;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateParam;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportPrepareRecord;
import kd.tmc.fpm.business.mvc.service.report.generate.enums.ExecuteResult;
import kd.tmc.fpm.business.mvc.service.report.generate.impl.ReportGenerateServiceImpl;
import kd.tmc.fpm.business.opservice.report.mutex.GeneralDLockStrategy;

public class FixedFrequencyGenReportService {
    private final IReportRepository reportRepository = new ReportRepository();
    private final IDimensionRepository dimensionRepository = new DimensionRepository();
    private final IDataSaveService dataSaveService = new DataSaveServiceImpl();
    private OperationResult operationResult;

    public FixedFrequencyGenReportService(OperationResult operationResult) {
        this.operationResult = operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixedFrequencyGenReport(Long reportPreparedId) {
        block17: {
            ReportPrepare prepare = this.reportRepository.loadReportPrepare(reportPreparedId);
            String reportPrepareLockName = String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), "fpm_taskrecord", prepare.getSystemId(), reportPreparedId);
            GeneralDLockStrategy dLockStrategy = new GeneralDLockStrategy(reportPrepareLockName);
            FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(prepare.getSystemId());
            try {
                if (dLockStrategy.tryLock()) {
                    try (TXHandle ignore = TX.requiresNew();){
                        ReportGenerateServiceImpl reportGenerateService = new ReportGenerateServiceImpl();
                        reportGenerateService.generate(new ReportGenerateParam(prepare, fundPlanSystem));
                    }
                    String msg = (String)DB.query((DBRoute)DBRouteConst.TMC, (String)"select top 1 fexecresult,fexecresultdetail from t_fpm_fpmbillgenrecord where fid=? order by fexectime desc", (Object[])new Object[]{reportPreparedId}, (ResultSetHandler)new ResultSetHandler<String>(){

                        public String handle(ResultSet resultSet) throws Exception {
                            if (resultSet.next()) {
                                String execResult = resultSet.getString("fexecresult");
                                if (!Objects.equals(execResult, ExecuteResult.FAILURE.getNumber())) {
                                    return "";
                                }
                                return resultSet.getString("fexecresultdetail");
                            }
                            return "";
                        }
                    });
                    this.error(prepare, msg);
                    break block17;
                }
                this.dataSaveService.updateBySqlInfo(() -> "update t_fpm_fpmbillgenrecord set fseq=fseq+1 where fid=?", Collections.singletonList(reportPreparedId), (t, d) -> d.add(t));
                ReportPrepareRecord reportPrepareRecord = ReportPrepareRecord.error(ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ReportBizService_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.error(prepare, reportPrepareRecord.getDetail());
                this.dataSaveService.saveEntryDataThrow(Collections.singletonList(reportPrepareRecord), reportPreparedId);
            }
            finally {
                dLockStrategy.unLock();
            }
        }
    }

    private void error(ReportPrepare reportPrepare, String msg) {
        if (EmptyUtil.isEmpty((String)msg)) {
            return;
        }
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setMessage(reportPrepare.getNumber() + ":" + String.join((CharSequence)";", msg));
        operateErrorInfo.setPkValue((Object)reportPrepare.getId());
        this.operationResult.addErrorInfo(operateErrorInfo);
        this.operationResult.setSuccess(false);
    }
}

