/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.basesetting;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.opservice.basesetting.FixedFrequencyGenReportService;
import kd.tmc.fpm.common.enums.ReportPrepareExecResultEnum;
import kd.tmc.fpm.common.helper.StringHelper;
import org.apache.commons.collections.CollectionUtils;

public class ReportPreparationGenReportService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        FixedFrequencyGenReportService fixedFrequencyGenReportService = new FixedFrequencyGenReportService(this.operationResult);
        List idList = Arrays.stream(dynamicObjects).map(item -> (Long)item.get("id")).collect(Collectors.toList());
        DynamicObject[] dbDataArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_reportpreparation"));
        Map dbDataMap = Arrays.stream(dbDataArr).collect(Collectors.toMap(item -> item.getPkValue(), Function.identity()));
        for (DynamicObject dynamicObject : dynamicObjects) {
            ReportBizService reportBizService = new ReportBizService();
            DynamicObject dbData = (DynamicObject)dbDataMap.get(dynamicObject.getPkValue());
            boolean fixedFrequency = dbData.getBoolean("fixedfrequency");
            if (fixedFrequency) {
                fixedFrequencyGenReportService.fixedFrequencyGenReport(Long.valueOf(dbData.getPkValue().toString()));
                continue;
            }
            FpmOperateResult<List<Long>> result = reportBizService.generateReportByPrepareId(Long.valueOf(dbData.getPkValue().toString()));
            DynamicObjectCollection entryColl = dbData.getDynamicObjectCollection("entryentity");
            DynamicObject newEntryData = entryColl.addNew();
            newEntryData.set("exectime", (Object)new Date());
            newEntryData.set("seq", (Object)1);
            if (result.isSuccess()) {
                List<Long> dataList = result.getData();
                List reportIdList = dataList.stream().map(item -> item.toString()).collect(Collectors.toList());
                newEntryData.set("execresult", (Object)ReportPrepareExecResultEnum.SUCCESS.getValue());
                String successInfo = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u751f\u6210\u8d44\u91d1\u8ba1\u5212\u5355\u636e%s\u6761\u3002", (String)"ReportPreparationGenReportService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), reportIdList.size());
                List<String> tipsInfoList = result.getTipsInfoList();
                if (CollectionUtils.isNotEmpty(tipsInfoList)) {
                    successInfo = String.format("%s;%s", successInfo, String.join((CharSequence)";", tipsInfoList));
                }
                newEntryData.set("execresultdetail", (Object)StringHelper.subStringAppendThreePoint((String)successInfo, (int)1000));
                newEntryData.set("planreportbillids_tag", (Object)String.join((CharSequence)";", reportIdList));
            } else {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(dynamicObject.get("number") + ":" + String.join((CharSequence)";", result.getMessageList()));
                operateErrorInfo.setPkValue(dynamicObject.getPkValue());
                this.operationResult.addErrorInfo(operateErrorInfo);
                this.operationResult.setSuccess(false);
                newEntryData.set("execresult", (Object)ReportPrepareExecResultEnum.FAIL.getValue());
                newEntryData.set("execresultdetail", (Object)StringHelper.subStringAppendThreePoint((String)String.join((CharSequence)";", result.getMessageList()), (int)1000));
            }
            newEntryData.set("opreateuser", (Object)RequestContext.get().getUserId());
            List entryCollList = entryColl.stream().filter(Objects::nonNull).sorted((o1, o2) -> {
                Date date1 = o1.getDate("exectime");
                Date date2 = o2.getDate("exectime");
                if (date1 == null || date2 == null) {
                    return 1;
                }
                return date1.compareTo(date2);
            }).collect(Collectors.toList());
            int tMaxSeq = entryColl.size();
            for (DynamicObject tEntryData : entryCollList) {
                tEntryData.set("seq", (Object)tMaxSeq--);
            }
        }
        SaveServiceHelper.save((DynamicObject[])dbDataArr);
    }
}

