/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;

public class SummaryConfigSyncService
extends AbstractTmcBizOppService {
    private static Log LOGGER = LogFactory.getLog(SummaryConfigSyncService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map operationVariable = this.getOperationVariable();
        OperationResult operationResult = this.getOperationResult();
        operationResult.setShowMessage(false);
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        String systemIdStr = (String)operationVariable.get("systemId");
        if (EmptyUtil.isEmpty((String)systemIdStr)) {
            LOGGER.info("\u4f20\u5165\u7684\u4f53\u7cfbId\u4e3a\u7a7a\uff0c\u4f20\u5165\u53c2\u6570:{}", (Object)operationVariable);
            operationResult.setSuccess(true);
            operationResult.setMessage(ResManager.loadKDString((String)"\u540c\u6b65\u66f4\u65b0\u6c47\u603b\u53c2\u6570\u6210\u529f\uff01", (String)"SummaryConfigSyncService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return;
        }
        try {
            Long systemId = Long.valueOf(systemIdStr);
            if (!TmcDataServiceHelper.exists((String)"fpm_summaryconfig", (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)systemId)})) {
                LOGGER.info("\u4f53\u7cfb:{}\uff0c\u5c1a\u672a\u914d\u7f6e\u6c47\u603b\u53c2\u6570\u3002\u3002\u3002", (Object)systemId);
                operationResult.setSuccess(true);
                operationResult.setMessage(ResManager.loadKDString((String)"\u540c\u6b65\u66f4\u65b0\u6c47\u603b\u53c2\u6570\u6210\u529f\uff01", (String)"SummaryConfigSyncService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            String currentIdStr = (String)operationVariable.get("currentId");
            QFilter filter = new QFilter("bodysystem", "=", (Object)systemId).and(new QFilter("dimtype", "=", (Object)DimensionType.ORG.getNumber()));
            String selectFields = String.join((CharSequence)",", "id", "parent", "longnumber");
            Object[] load = TmcDataServiceHelper.load((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isEmpty((Object[])load)) {
                LOGGER.info("\u67e5\u8be2\u4e0d\u5230\u6570\u636e,\u53c2\u6570\uff1a{}", (Object)operationVariable);
                return;
            }
            Map<Long, MemberUpdateInfo> updateInfoMap = Arrays.stream(load).filter(Objects::nonNull).map(MemberUpdateInfo::getMemberUpdateInfo).filter(Objects::nonNull).collect(Collectors.toMap(MemberUpdateInfo::getId, Function.identity()));
            this.doSync(updateInfoMap, currentIdStr, systemId);
            operationResult.setSuccess(true);
            operationResult.setMessage(ResManager.loadKDString((String)"\u540c\u6b65\u66f4\u65b0\u6c47\u603b\u53c2\u6570\u6210\u529f\uff01", (String)"SummaryConfigSyncService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            operationResult.setSuccess(false);
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(e.getMessage());
            operationResult.addErrorInfo(operateErrorInfo);
        }
    }

    private void doSync(Map<Long, MemberUpdateInfo> allOrgMap, String currentIdStr, Long systemId) {
        Long updateId;
        Object[] load = TmcDataServiceHelper.load((String)"fpm_summaryconfig", (String)"id", (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)systemId), new QFilter("enable", "=", (Object)"1")});
        if (EmptyUtil.isEmpty((Object[])load)) {
            LOGGER.info("\u4f53\u7cfb\uff1a{}\u4e0b\u6ca1\u6709\u914d\u7f6e\u6c47\u603b\u53c2\u6570");
            return;
        }
        Map<Long, MemberUpdateInfo> updateInfoMap = allOrgMap;
        if (EmptyUtil.isNoEmpty((String)currentIdStr) && EmptyUtil.isNoEmpty((Long)(updateId = Long.valueOf(currentIdStr)))) {
            updateInfoMap = Collections.singletonMap(updateId, allOrgMap.get(updateId));
        }
        List updateInfoList = allOrgMap.values().stream().sorted(Comparator.comparing(MemberUpdateInfo::getLongNumber)).collect(Collectors.toList());
        HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>(updateInfoList.size());
        for (int i = 0; i < updateInfoList.size(); ++i) {
            MemberUpdateInfo memberUpdateInfo = (MemberUpdateInfo)updateInfoList.get(i);
            indexMap.put(memberUpdateInfo.getId(), i + 1);
        }
        for (Object dynamicObject : load = TmcDataServiceHelper.load((Object[])Arrays.stream(load).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_summaryconfig"))) {
            Map<Object, DynamicObject> dynamicObjectMap;
            List<MemberUpdateInfo> needUpdateMemberUpdateInfo;
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("treeentryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection) || CollectionUtils.isEmpty(needUpdateMemberUpdateInfo = this.getNeedUpdateMemberUpdateInfo(updateInfoMap, dynamicObjectMap = dynamicObjectCollection.stream().collect(Collectors.toMap(dy -> dy.getDynamicObject("sum_reportorg").getPkValue(), Function.identity())), dynamicObjectCollection.getDynamicObjectType().getAlias()))) continue;
            for (MemberUpdateInfo memberUpdateInfo : needUpdateMemberUpdateInfo) {
                if (memberUpdateInfo.isUpdate()) {
                    DynamicObject entry = dynamicObjectMap.get(memberUpdateInfo.getId());
                    entry.set("pid", (Object)memberUpdateInfo.getTreeEntryParentId());
                    continue;
                }
                if (!memberUpdateInfo.isAdd()) continue;
                DynamicObject addNew = dynamicObjectCollection.addNew();
                addNew.set("pid", (Object)memberUpdateInfo.getTreeEntryParentId());
                DynamicObject sumReportOrg = TmcDataServiceHelper.newDynamicObject((String)"fpm_member");
                sumReportOrg.set("id", (Object)memberUpdateInfo.getId());
                addNew.set("sum_reportorg", (Object)sumReportOrg);
                addNew.set("id", (Object)memberUpdateInfo.getEntryId());
            }
            for (DynamicObject entry : dynamicObjectCollection) {
                Object pkValue = entry.getDynamicObject("sum_reportorg").getPkValue();
                entry.set("seq", indexMap.get(pkValue));
            }
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_summaryconfig", (DynamicObject[])load, (OperateOption)OperateOption.create());
    }

    private List<MemberUpdateInfo> getNeedUpdateMemberUpdateInfo(Map<Long, MemberUpdateInfo> updateInfoMap, Map<Object, DynamicObject> dynamicObjectMap, String tableName) {
        ArrayList<MemberUpdateInfo> memberUpdateInfoList = new ArrayList<MemberUpdateInfo>(updateInfoMap.size());
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(64);
        HashSet<Long> retain = new HashSet<Long>(updateInfoMap.keySet());
        retain.retainAll(dynamicObjectMap.keySet());
        HashSet<Long> needGenIdSet = new HashSet<Long>(updateInfoMap.keySet());
        needGenIdSet.removeAll(retain);
        long[] genLongIds = DB.genLongIds((String)tableName, (int)needGenIdSet.size());
        int index = 0;
        for (Long orgId : needGenIdSet) {
            idMap.put(orgId, genLongIds[index]);
            ++index;
        }
        Map objectMap = dynamicObjectMap.values().stream().collect(Collectors.toMap(dy -> dy.getPkValue(), Function.identity()));
        for (Map.Entry<Long, MemberUpdateInfo> entry : updateInfoMap.entrySet()) {
            MemberUpdateInfo sumEntryMemberUpdateInfo;
            DynamicObject dynamicObject;
            Long id = entry.getKey();
            MemberUpdateInfo memberUpdateInfo = entry.getValue();
            if (!dynamicObjectMap.containsKey(id)) {
                MemberUpdateInfo copy = memberUpdateInfo.copy();
                this.setTreePidIfNeed(dynamicObjectMap, idMap, copy);
                copy.setType(1);
                memberUpdateInfoList.add(copy);
                continue;
            }
            DynamicObject treeEntryObj = dynamicObjectMap.get(id);
            DynamicObject reportOrg = treeEntryObj.getDynamicObject("sum_reportorg");
            Long pid = treeEntryObj.getLong("pid");
            Long parentId = 0L;
            if (EmptyUtil.isNoEmpty((Long)pid) && EmptyUtil.isNoEmpty((DynamicObject)(dynamicObject = (DynamicObject)objectMap.get(pid)))) {
                parentId = (Long)dynamicObject.getDynamicObject("sum_reportorg").getPkValue();
            }
            if (Objects.equals(memberUpdateInfo, sumEntryMemberUpdateInfo = new MemberUpdateInfo((Long)reportOrg.getPkValue(), parentId))) continue;
            MemberUpdateInfo copy = memberUpdateInfo.copy();
            copy.setOriginalParentId(sumEntryMemberUpdateInfo.getParentId());
            this.setTreePidIfNeed(dynamicObjectMap, idMap, copy);
            copy.setType(2);
            memberUpdateInfoList.add(copy);
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u66f4\u65b0\u6c47\u603b\u53c2\u6570\u64cd\u4f5c\u5931\u8d25\uff0c\u7f16\u62a5\u4e3b\u4f53\u6811\u7ed3\u6784\u5b58\u5728\u590d\u6742\u7ea7\u522b\u8c03\u6574\u65f6\u8bf7\u901a\u8fc7\u65b0\u589e\u6c47\u603b\u53c2\u6570\u5904\u7406\u3002", (String)"SummaryConfigSyncService_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return memberUpdateInfoList;
    }

    private void setTreePidIfNeed(Map<Object, DynamicObject> dynamicObjectMap, Map<Long, Long> idMap, MemberUpdateInfo copy) {
        Long parentId = copy.getParentId();
        copy.setEntryId(idMap.get(copy.getId()));
        if (dynamicObjectMap.containsKey(parentId)) {
            DynamicObject dynamicObject = dynamicObjectMap.get(parentId);
            copy.setTreeEntryParentId(dynamicObject.getLong("id"));
        } else if (EmptyUtil.isEmpty((Long)parentId)) {
            copy.setTreeEntryParentId(0L);
        } else {
            copy.setTreeEntryParentId(idMap.get(parentId));
        }
    }

    static class MemberUpdateInfo {
        private Long id;
        private Long parentId = 0L;
        private Long originalParentId = 0L;
        private int type;
        private String longNumber;
        private Long treeEntryParentId = 0L;
        private Long entryId;

        public MemberUpdateInfo() {
        }

        public MemberUpdateInfo(Long id, Long parentId) {
            this.id = id;
            this.parentId = parentId;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getParentId() {
            return this.parentId;
        }

        public void setParentId(Long parentId) {
            this.parentId = parentId;
        }

        public Long getOriginalParentId() {
            return this.originalParentId;
        }

        public void setOriginalParentId(Long originalParentId) {
            this.originalParentId = originalParentId;
        }

        public boolean isAdd() {
            return this.type == 1;
        }

        public boolean isUpdate() {
            return this.type == 2;
        }

        public void setType(int type) {
            this.type = type;
        }

        public Long getTreeEntryParentId() {
            return this.treeEntryParentId;
        }

        public void setTreeEntryParentId(Long treeEntryParentId) {
            this.treeEntryParentId = treeEntryParentId;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public void setEntryId(Long entryId) {
            this.entryId = entryId;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberUpdateInfo that = (MemberUpdateInfo)o;
            return this.type == that.type && Objects.equals(this.id, that.id) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.originalParentId, that.originalParentId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.parentId, this.originalParentId, this.type);
        }

        public MemberUpdateInfo copy() {
            MemberUpdateInfo memberUpdateInfo = new MemberUpdateInfo();
            memberUpdateInfo.setId(this.id);
            memberUpdateInfo.setParentId(this.parentId);
            memberUpdateInfo.setLongNumber(this.longNumber);
            return memberUpdateInfo;
        }

        public static MemberUpdateInfo getMemberUpdateInfo(DynamicObject orgObj) {
            if (Objects.isNull(orgObj)) {
                return null;
            }
            MemberUpdateInfo memberUpdateInfo = new MemberUpdateInfo();
            memberUpdateInfo.setId((Long)orgObj.getPkValue());
            DynamicObject parentObj = orgObj.getDynamicObject("parent");
            Long parentId = EmptyUtil.isEmpty((DynamicObject)parentObj) ? Long.valueOf(0L) : (Long)parentObj.getPkValue();
            memberUpdateInfo.setParentId(parentId);
            memberUpdateInfo.setLongNumber(orgObj.getString("longnumber"));
            return memberUpdateInfo;
        }
    }
}

