/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fpm.business.domain.model.control.ControlExecTimeRule;
import kd.tmc.fpm.business.mvc.converter.ControlExecTimeConverter;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ControlRepository;
import kd.tmc.fpm.business.mvc.service.control.executetime.IExecuteTimeAutoReverseWriteOpRuleService;
import kd.tmc.fpm.business.mvc.service.control.executetime.impl.ExecuteTimeAutoReverseWriteOpRuleServiceImpl;
import kd.tmc.fpm.business.mvc.service.lock.DLockService;
import kd.tmc.fpm.common.property.ExecuteTimeProp;

public class WriteControlExecTimeService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(WriteControlExecTimeService.class);
    private final IControlRepository dimRepo = new ControlRepository();
    private DLockService dLockService;
    private final IExecuteTimeAutoReverseWriteOpRuleService executeTimeAutoReverseWriteOpRuleService = new ExecuteTimeAutoReverseWriteOpRuleServiceImpl();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.addAll(ExecuteTimeProp.QUERY_RULE_PROPS);
        selector.add("bodysys");
        return selector;
    }

    public void process(DynamicObject[] dataEntitys) throws KDException {
        Long systemId = dataEntitys[0].getDynamicObject("bodysys").getLong("id");
        DynamicObject systemDy = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)systemId)});
        ArrayList<ControlExecTimeRule> rules = systemDy.getBoolean("enable") ? ControlExecTimeConverter.batchConverterControlExecTimeRule(dataEntitys) : new ArrayList<ControlExecTimeRule>(10);
        Set<Long> excludeSystemIds = Arrays.stream(dataEntitys).map(dy -> dy.getDynamicObject("bodysys")).filter(Objects::nonNull).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        rules.addAll(this.dimRepo.queryControlExecTimeRule(excludeSystemIds));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.executeTimeAutoReverseWriteOpRuleService.reverseWrite(rules);
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        String dLockName = String.format("%s.%s", CacheKeyUtil.getAcctId(), "executeTime");
        this.dLockService = new DLockService(dLockName);
        try {
            this.dLockService.tryLock(30000L);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (Objects.nonNull(this.dLockService)) {
            this.dLockService.unLock();
        }
    }
}

