/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.MemberSumEnum;

public class OrgMemberSaveService
extends AbstractTmcBizOppService {
    private static final String ORGMEMBER = "fpm_member";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("parent");
        selector.add("bodysystem");
        selector.add("dimtype");
        selector.add("isleaf");
        selector.add("issum");
        selector.add("level");
        selector.add("enabledate");
        selector.add("sumtype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List memberIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List memberParentIds = Arrays.stream(dataEntities).filter(v -> Objects.nonNull(v.getDynamicObject("parent"))).map(v -> v.getDynamicObject("parent").getPkValue()).collect(Collectors.toList());
        DynamicObject[] membersFromDB = TmcDataServiceHelper.load((Object[])memberIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ORGMEMBER));
        HashMap memberFromDBMap = Arrays.stream(membersFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        for (DynamicObject member : dataEntities) {
            Object disabledate;
            Object enabledate;
            block16: {
                DynamicObject parent;
                DynamicObject memberFromDB = memberFromDBMap.getOrDefault(member.getPkValue(), null);
                if (EmptyUtil.isEmpty((DynamicObject)memberFromDB)) {
                    member.set("sumtype", (Object)MemberSumEnum.PLUS.getCode());
                }
                if ((parent = member.getDynamicObject("parent")) != null && parent.getPkValue() != null) {
                    try {
                        Object partentlLevel;
                        DynamicObject parentFromDB = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ORGMEMBER));
                        if (parentFromDB.getBoolean("isleaf")) {
                            parentFromDB.set("isleaf", (Object)false);
                            parentFromDB.set("issum", (Object)true);
                        }
                        if ((partentlLevel = parentFromDB.get("level")) == null) {
                            parentFromDB.set("level", (Object)1);
                        }
                        member.set("level", (Object)(parentFromDB.getInt("level") + 1));
                    }
                    catch (Exception e) {
                        if (memberParentIds.contains(member.getPkValue())) {
                            member.set("isleaf", (Object)false);
                            member.set("issum", (Object)true);
                            break block16;
                        }
                        member.set("isleaf", (Object)true);
                        member.set("issum", (Object)false);
                    }
                } else {
                    member.set("level", (Object)1);
                    if (EmptyUtil.isNoEmpty((DynamicObject)memberFromDB)) {
                        parent = memberFromDB.getDynamicObject("parent");
                        if (parent != null && parent.getPkValue() != null && !QueryServiceHelper.exists((String)ORGMEMBER, (QFilter[])new QFilter[]{new QFilter("parent", "=", parent.getPkValue()).and("id", "!=", member.getPkValue())})) {
                            parent = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ORGMEMBER));
                            parent.set("isleaf", (Object)true);
                            parent.set("issum", (Object)false);
                        }
                    } else if (memberParentIds.contains(member.getPkValue())) {
                        member.set("isleaf", (Object)false);
                        member.set("issum", (Object)true);
                    } else {
                        member.set("isleaf", (Object)true);
                        member.set("issum", (Object)false);
                    }
                }
            }
            List<DynamicObject> tChildren = this.getAllChildNodeID(member, member.getInt("level"));
            boolean isLeaf = member.getBoolean("isleaf");
            if (isLeaf && tChildren.size() > 0) {
                member.set("isleaf", (Object)false);
            }
            if ((enabledate = member.get("enabledate")) == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1900, 0, 1);
                Date enableDate = calendar.getTime();
                member.set("enabledate", (Object)enableDate);
            }
            if ((disabledate = member.get("disabledate")) != null) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.set(2099, 11, 31);
            Date disableDate = calendar.getTime();
            member.set("disabledate", (Object)disableDate);
        }
    }

    private List<DynamicObject> getAllChildNodeID(DynamicObject member, int tParentLevel) {
        ArrayList<DynamicObject> childItems = new ArrayList<DynamicObject>(0);
        DynamicObject[] col = BusinessDataServiceHelper.load((String)ORGMEMBER, (String)"id,number,name,parent.id,level", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", member.getDynamicObject("bodysystem").getPkValue()).and("dimtype", "=", (Object)member.getString("dimtype"))});
        childItems.addAll(this.getChildNodeID(col, member.getLong("id"), tParentLevel));
        return childItems;
    }

    private List<DynamicObject> getChildNodeID(DynamicObject[] col, Long parentID, int tParentLevel) {
        ArrayList<DynamicObject> childItems = new ArrayList<DynamicObject>();
        ++tParentLevel;
        for (DynamicObject dynamicObject : col) {
            if (parentID.compareTo(dynamicObject.getLong("parent.id")) != 0) continue;
            dynamicObject.set("level", (Object)tParentLevel);
            childItems.add(dynamicObject);
            childItems.addAll(this.getChildNodeID(col, dynamicObject.getLong("id"), tParentLevel));
        }
        return childItems;
    }
}

