/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.inoutpool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncDataManager;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fpm.common.enums.InoutCollectDataSourceEnum;
import org.apache.commons.collections4.CollectionUtils;

public class SmartCollectSyncDataUpdateService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List props = super.getSelector();
        props.add("datasource");
        props.add(String.join((CharSequence)".", "sourcebill", "id"));
        props.add("sourcebillid");
        return props;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        String sourceBillProp = String.join((CharSequence)".", "sourcebill", "id");
        HashMap<String, Set> sourceBillDataMap = new HashMap<String, Set>(8);
        Arrays.stream(dynamicObjects).filter(dy -> Objects.equals(InoutCollectDataSourceEnum.INTELLIGENT_COLLECT.getCode(), dy.getString("datasource"))).forEach(dy -> {
            String sourceBillType = dy.getString(sourceBillProp);
            Set sourceBillIds = sourceBillDataMap.computeIfAbsent(sourceBillType, val -> new HashSet(8));
            sourceBillIds.add(dy.getLong("sourcebillid"));
        });
        if (sourceBillDataMap.isEmpty()) {
            return;
        }
        HashMap dataMgrMap = new HashMap(8);
        sourceBillDataMap.forEach((sourceBillType, sourceBillIds) -> {
            SyncDataManager syncDataManager = dataMgrMap.computeIfAbsent(sourceBillType, SyncDataManager::new);
            List syncInfo = syncDataManager.getSyncInfo(new ArrayList(sourceBillIds));
            List syncDataList = syncInfo.stream().filter(info -> info.getStatus() == 0 || info.getStatus() == 1).map(info -> {
                HashMap<String, Number> syncInfoMap = new HashMap<String, Number>(2, 1.0f);
                syncInfoMap.put("__KEY_DATA_ID", info.getId());
                syncInfoMap.put("__KEY_VERSION", info.getVersion());
                return syncInfoMap;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(syncDataList)) {
                return;
            }
            CommonParam param = new CommonParam();
            param.put((Object)"__ENTITY_TYPE", sourceBillType);
            param.put((Object)"__DATA", syncDataList);
            param.put((Object)"__OPERATE_TYPE", (Object)"UPDATE");
            param.put((Object)"__OPERATE_STATUS", (Object)0);
            ECGlobalSession.begin((String)"fpm_etlupdate", (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
            ECGlobalSession.setAsync((boolean)true);
            ECGlobalSession.register((String)"tmc", (String)"fpm", (String)"FpmETLUpdateDataService", (Param)param);
        });
    }
}

