/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.inspection;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.enums.InspectionExecType;
import kd.tmc.fpm.business.domain.model.inspection.DateRange;
import kd.tmc.fpm.business.domain.model.inspection.header.InspectHeader;
import kd.tmc.fpm.business.mvc.service.inspection.IInspectionExecuteBizService;
import kd.tmc.fpm.business.opservice.inspection.ExecuteInspectionTaskService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class InspectControlTraceTaskService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ExecuteInspectionTaskService.class);
    private final IInspectionExecuteBizService inspectionExecuteBizService = FpmServiceFactory.getBizService(IInspectionExecuteBizService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("number");
        selector.add("name");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        DateRange dateRange = this.getDateRange();
        for (DynamicObject dynamicObject : dataEntities) {
            try {
                InspectHeader inspectHeader = new InspectHeader();
                inspectHeader.setInspectionConfigId((Long)dynamicObject.getPkValue());
                inspectHeader.setExecType(InspectionExecType.BY_DATE);
                inspectHeader.setStartDate(dateRange.getStartDate());
                inspectHeader.setEndDate(dateRange.getEndDate());
                inspectHeader.setControlTraceInspect(true);
                this.inspectionExecuteBizService.execute(inspectHeader);
            }
            catch (Exception e) {
                logger.error("\u5de1\u68c0\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u5de1\u68c0\u914d\u7f6e\uff1a[{}]\uff0c\u5de1\u68c0\u914d\u7f6eid\uff1a[{}]", (Object)(dynamicObject.getString("number") + " " + dynamicObject.getString("name")), dynamicObject.getPkValue());
            }
        }
    }

    private DateRange getDateRange() {
        String dayScope = (String)this.getOperationVariable().get("day_scope");
        Date now = DateUtils.getCurrentDate();
        if (Objects.isNull(dayScope)) {
            return new DateRange(now, now);
        }
        switch (dayScope) {
            case "CURR_WEEK": {
                return new DateRange(DateUtils.getFirstDayOfWeek((Date)now), DateUtils.getLastDay((Date)DateUtils.getNextWeekMonday((Date)now), (int)1));
            }
            case "CURR_MONTH": {
                return new DateRange(DateUtils.getFirstDayOfCurMonth(), DateUtils.getLastDayOfCurMonth());
            }
            case "LAST_MONTH": {
                return new DateRange(DateUtils.getLastMonth((Date)now, (int)1), now);
            }
        }
        return new DateRange(now, now);
    }
}

